/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal.command.render;

import java.util.Map;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.ControllerException;
import org.jboss.portal.core.controller.ControllerResponse;
import org.jboss.portal.core.controller.NoSuchResourceException;
import org.jboss.portal.core.controller.command.info.CommandInfo;
import org.jboss.portal.core.controller.command.info.ViewCommandInfo;
import org.jboss.portal.core.controller.portlet.ControllerPageNavigationalState;
import org.jboss.portal.core.controller.portlet.PortletInvocationFactory;
import org.jboss.portal.core.model.content.ContentType;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.command.WindowCommand;
import org.jboss.portal.core.model.portal.content.ContentRenderer;
import org.jboss.portal.core.model.portal.content.ContentRendererContext;
import org.jboss.portal.core.model.portal.content.ContentRendererRegistry;
import org.jboss.portal.core.model.portal.content.WindowRendition;
import org.jboss.portal.core.model.portal.control.page.PageControlContext;
import org.jboss.portal.identity.User;
import org.jboss.portal.portlet.controller.state.PortletWindowNavigationalState;
import org.jboss.portal.portlet.invocation.RenderInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderWindowCommand
extends WindowCommand
implements ContentRendererContext {
    private static final CommandInfo info = new ViewCommandInfo();
    private WindowRendition rendition;
    private ControllerPageNavigationalState pageNavigationalState;

    public RenderWindowCommand(ControllerPageNavigationalState pageNavigationalState, PortalObjectId windowId) throws IllegalArgumentException {
        super(windowId);
        this.pageNavigationalState = pageNavigationalState;
    }

    @Override
    public CommandInfo getInfo() {
        return info;
    }

    public WindowRendition render(ControllerContext ctx) throws ControllerException {
        ctx.execute(this);
        return this.rendition;
    }

    @Override
    public ControllerResponse execute() throws ControllerException {
        ContentType contentType;
        ContentRendererRegistry registry = this.context.getController().getContentRendererRegistry();
        ContentRenderer renderer = registry.getRenderer(contentType = this.window.getContentType());
        if (renderer != null) {
            this.rendition = renderer.renderWindow(this);
            if (this.rendition != null) {
                PageControlContext wcc = new PageControlContext(this.context, this.targetId, this.rendition);
                this.context.getController().getPageControlPolicy().doControl(wcc);
            }
        }
        return null;
    }

    public Map<String, String[]> getPublicNavigationalState() {
        return this.pageNavigationalState.getPortletPublicNavigationalState(this.window.getName());
    }

    @Override
    public PortletWindowNavigationalState getPortletNavigationalState() {
        return this.pageNavigationalState.getPortletWindowNavigationalState(this.window.getName());
    }

    @Override
    public User getUser() {
        return this.context.getUser();
    }

    @Override
    public RenderInvocation createRenderInvocation(PortletWindowNavigationalState navigationalState) {
        return PortletInvocationFactory.createRender(this.context, navigationalState.getMode(), navigationalState.getWindowState(), navigationalState.getPortletNavigationalState(), this.window, this.portal, this.pageNavigationalState);
    }

    @Override
    public void acquireResources() throws NoSuchResourceException {
        super.acquireResources();
    }
}

