/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity;

import java.util.Collection;
import org.jboss.logging.Logger;
import org.jboss.portal.common.util.CopyOnWriteRegistry;
import org.jboss.portal.identity.IdentityContext;
import org.jboss.portal.identity.IdentityException;

public class IdentityContextImpl
implements IdentityContext {
    private static final Logger log = Logger.getLogger(IdentityContextImpl.class);
    private final CopyOnWriteRegistry registry = new CopyOnWriteRegistry();

    public void register(Object object, String name) throws IdentityException {
        if (!this.registry.register((Object)name, object)) {
            throw new IdentityException("Cannot register object in IdentityContext with name: " + name);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("registering object: " + name + " ; " + object.getClass()));
        }
    }

    public void unregister(String name) {
        if (this.registry.unregister((Object)name) == null) {
            log.error((Object)("Cannot unregister object from IdentityContext with name: " + name));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("unregistering object: " + name));
        }
    }

    public Object getObject(String name) throws IdentityException {
        Object o = this.registry.getRegistration((Object)name);
        if (o == null) {
            throw new IdentityException("No such mapping in IdentityContext: " + name);
        }
        return o;
    }

    public Collection getKeys() {
        return this.registry.getKeys();
    }

    public Collection getValues() {
        return this.registry.getRegistrations();
    }
}

