/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.ldap;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.ldap.LDAPConnectionContext;
import org.jboss.portal.identity.ldap.LDAPRoleModule;
import org.jboss.portal.identity.ldap.LDAPUserModule;
import org.jboss.portal.identity.service.MembershipModuleService;

public abstract class LDAPMembershipModule
extends MembershipModuleService {
    private static final Logger log = Logger.getLogger(LDAPMembershipModule.class);
    private LDAPConnectionContext connectionContext;
    private LDAPUserModule userModule;
    private LDAPRoleModule roleModule;

    public void start() throws Exception {
        if (this.getConnectionJNDIName() == null) {
            throw new IdentityException("Cannot obtain ldap connection context JNDI name");
        }
        try {
            this.connectionContext = (LDAPConnectionContext)new InitialContext().lookup(this.getConnectionJNDIName());
        }
        catch (NamingException e) {
            log.error((Object)"Couldn't obtain connection context");
        }
        super.start();
    }

    protected LDAPConnectionContext getConnectionContext() throws IdentityException {
        if (this.connectionContext == null) {
            try {
                this.connectionContext = (LDAPConnectionContext)this.getIdentityContext().getObject("ConnectionContext");
            }
            catch (IdentityException e) {
                throw new IdentityException("No LDAPConnectionContext available");
            }
        }
        return this.connectionContext;
    }

    protected LDAPUserModule getUserModule() throws IdentityException {
        if (this.userModule == null) {
            try {
                this.userModule = (LDAPUserModule)this.getIdentityContext().getObject("User");
            }
            catch (ClassCastException e) {
                throw new IdentityException("Not supported object as part of the context - must be LDAPUserModule", e);
            }
        }
        return this.userModule;
    }

    protected LDAPRoleModule getRoleModule() throws IdentityException {
        if (this.roleModule == null) {
            try {
                this.roleModule = (LDAPRoleModule)this.getIdentityContext().getObject("Role");
            }
            catch (ClassCastException e) {
                throw new IdentityException("Not supported object as part of the context", e);
            }
        }
        return this.roleModule;
    }

    protected String getMemberAttributeID() throws IdentityException {
        String uid = this.getIdentityConfiguration().getValue("membershipAttributeID");
        if (uid == null) {
            return "member";
        }
        return uid;
    }

    protected boolean isUidAttributeIsDN() throws IdentityException {
        if (this.getIdentityConfiguration().getValue("membershipAttributeIsDN") == null) {
            return true;
        }
        return this.getIdentityConfiguration().getValue("membershipAttributeIsDN").equals("true");
    }

    protected boolean isMembershipAttributeRequired() throws IdentityException {
        if (this.getIdentityConfiguration().getValue("membershipAttributeRequired") == null) {
            return true;
        }
        return this.getIdentityConfiguration().getValue("membershipAttributeRequired").equals("true");
    }

    protected String getMembershipAttributeValue() throws IdentityException {
        String value = this.getIdentityConfiguration().getValue("membershipAttributeID");
        if (value == null) {
            return "cn=emptyMembershipValue";
        }
        return value;
    }

    public void setConnectionContext(LDAPConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }
}

