/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.impl.jsr168.api;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletMode;
import javax.portlet.RenderResponse;
import org.jboss.portal.Mode;
import org.jboss.portal.common.net.media.MediaType;
import org.jboss.portal.portlet.cache.CacheControl;
import org.jboss.portal.portlet.impl.info.ContainerPortletInfo;
import org.jboss.portal.portlet.impl.jsr168.api.MimeResponseImpl;
import org.jboss.portal.portlet.impl.jsr168.api.PortletRequestImpl;
import org.jboss.portal.portlet.info.CapabilitiesInfo;
import org.jboss.portal.portlet.info.ModeInfo;
import org.jboss.portal.portlet.invocation.RenderInvocation;
import org.jboss.portal.portlet.invocation.response.ContentResponse;
import org.jboss.portal.portlet.invocation.response.FragmentResponse;
import org.jboss.portal.portlet.invocation.response.ResponseProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderResponseImpl
extends MimeResponseImpl
implements RenderResponse {
    protected Set<Mode> responseNextModes = null;
    protected String responseTitle = null;

    public RenderResponseImpl(RenderInvocation invocation, PortletRequestImpl preq) {
        super(invocation, preq);
    }

    public void setTitle(String title) {
        this.responseTitle = title;
    }

    public void setNextPossiblePortletModes(Collection<PortletMode> portletModes) {
        if (portletModes != null && portletModes.size() > 0) {
            if (this.responseNextModes == null) {
                this.responseNextModes = new LinkedHashSet<Mode>(portletModes.size());
            } else {
                this.responseNextModes.clear();
            }
            for (PortletMode portletMode : portletModes) {
                Mode mode;
                if (portletMode == null || !this.preq.supportedModes.contains(mode = Mode.create((String)portletMode.toString()))) continue;
                this.responseNextModes.add(mode);
            }
        }
    }

    @Override
    public void setContentType(String contentType) {
        int index = contentType.indexOf(59);
        if (index != -1) {
            contentType = contentType.substring(0, index);
        }
        Mode currentMode = this.preq.invocation.getMode();
        MediaType mediaType = MediaType.create((String)contentType);
        ContainerPortletInfo info = this.preq.container.getInfo();
        CapabilitiesInfo capabilities = info.getCapabilities();
        Set<ModeInfo> compatibleModes = capabilities.getModes(mediaType);
        for (ModeInfo modeInfo : compatibleModes) {
            if (!currentMode.equals((Object)modeInfo.getMode())) continue;
            super.setContentType(contentType);
            return;
        }
        throw new IllegalArgumentException("Mime type " + contentType + " not accepted as content type");
    }

    @Override
    protected ContentResponse createMarkupResponse(ResponseProperties properties, Map<String, Object> attributeMap, String contentType, byte[] bytes, String chars, CacheControl cacheControl) {
        return new FragmentResponse(properties, attributeMap, contentType, bytes, chars, this.responseTitle, cacheControl, this.responseNextModes != null ? this.responseNextModes : this.preq.supportedModes);
    }
}

