/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.registration.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.portal.common.util.ParameterValidation;
import org.jboss.portal.registration.Consumer;
import org.jboss.portal.registration.ConsumerGroup;
import org.jboss.portal.registration.NoSuchRegistrationException;
import org.jboss.portal.registration.RegistrationException;
import org.jboss.portal.registration.RegistrationStatus;

public class ConsumerGroupImpl
implements ConsumerGroup {
    private String name;
    private Map consumers;
    private RegistrationStatus status;

    private ConsumerGroupImpl() {
        this.init();
    }

    ConsumerGroupImpl(String name) {
        this.name = name;
        this.init();
    }

    private void init() {
        this.consumers = new HashMap();
        this.status = RegistrationStatus.PENDING;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsumerGroupImpl that = (ConsumerGroupImpl)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public RegistrationStatus getStatus() {
        return this.status;
    }

    public void setStatus(RegistrationStatus status) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)status, (String)"RegistrationStatus");
        this.status = status;
    }

    public Collection getConsumers() throws RegistrationException {
        return Collections.unmodifiableCollection(this.consumers.values());
    }

    public Consumer getConsumer(String consumerId) throws IllegalArgumentException, RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerId, (String)"Consumer name", null);
        return (Consumer)this.consumers.get(consumerId);
    }

    public boolean isEmpty() {
        return this.consumers.isEmpty();
    }

    public void addConsumer(Consumer consumer) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)consumer, (String)"Consumer");
        String identity = consumer.getId();
        if (this.consumers.containsKey(identity)) {
            throw new IllegalArgumentException("ConsumerGroup named '" + this.name + "' already contains a Consumer named '" + consumer.getName() + "' (identity: '" + identity + "')");
        }
        this.consumers.put(identity, consumer);
        consumer.setGroup(this);
    }

    public void removeConsumer(Consumer consumer) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)consumer, (String)"Consumer");
        if (this.consumers.remove(consumer.getId()) == null) {
            throw new NoSuchRegistrationException("ConsumerGroup named '" + this.name + "' does not contain a Consumer named '" + consumer.getName() + "' (identity: '" + consumer.getId() + "')");
        }
        consumer.setGroup(null);
    }

    public boolean contains(Consumer consumer) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)consumer, (String)"Consumer");
        return this.consumers.containsKey(consumer.getId());
    }
}

