/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.tribu.api;

import fr.gouv.education.tribu.api.directory.dao.converter.DateToGeneralizedTime;
import fr.gouv.education.tribu.api.directory.dao.converter.GeneralizedTimeToDate;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.odm.core.ObjectDirectoryMapper;
import org.springframework.ldap.odm.core.impl.DefaultObjectDirectoryMapper;
import org.springframework.ldap.odm.typeconversion.ConverterManager;
import org.springframework.ldap.odm.typeconversion.impl.ConversionServiceConverterManager;
import org.springframework.ldap.pool2.factory.PoolConfig;
import org.springframework.ldap.pool2.factory.PooledContextSource;
import org.springframework.ldap.pool2.validation.DefaultDirContextValidator;
import org.springframework.ldap.pool2.validation.DirContextValidator;
import org.springframework.ldap.transaction.compensating.TempEntryRenamingStrategy;
import org.springframework.ldap.transaction.compensating.manager.ContextSourceTransactionManager;
import org.springframework.ldap.transaction.compensating.manager.ContextSourceTransactionManagerDelegate;
import org.springframework.ldap.transaction.compensating.manager.TransactionAwareContextSourceProxy;
import org.springframework.ldap.transaction.compensating.support.DefaultTempEntryRenamingStrategy;

@Configuration
public class DirectoryFrameworkConfiguration {
    private ApplicationContext context;
    public static final String BASE_DN_CONF = "${ldap.base:dc=osivia,dc=org}";
    @Value(value="${ldap.url}")
    private String ldapUrl;
    @Value(value="${ldap.manager.dn}")
    private String ldapManagerDn;
    @Value(value="${ldap.manager.pswd}")
    private String ldapManagerPswd;
    @Value(value="${ldap.timeout:10000}")
    private String ldapTimeout;
    @Value(value="${ldap.pool.testOnBorrow:true}")
    private Boolean testOnBorrow;
    @Value(value="${ldap.pool.testWhileIdle:true}")
    private Boolean testWhileIdle;
    @Value(value="${ldap.pool.minEvictableIdleTimeMillis:600000}")
    private Long minEvictableIdleTimeMillis;
    @Value(value="${ldap.pool.timeBetweenEvictionRunsMillis:300000}")
    private Long timeBetweenEvictionRunsMillis;

    public DirectoryFrameworkConfiguration(ApplicationContext context) {
        this.context = context;
    }

    @Bean(name={"contextSourceTransactionAwareProxy"})
    public TransactionAwareContextSourceProxy txProxy() {
        LdapContextSource source = new LdapContextSource();
        source.setUrl(this.ldapUrl);
        source.setUserDn(this.ldapManagerDn);
        source.setPassword(this.ldapManagerPswd);
        source.setPooled(false);
        HashMap<String, String> baseEnvironmentProperties = new HashMap<String, String>();
        baseEnvironmentProperties.put("com.sun.jndi.ldap.connect.timeout", this.ldapTimeout);
        source.setBaseEnvironmentProperties(baseEnvironmentProperties);
        source.afterPropertiesSet();
        PooledContextSource configurePooling = this.configurePooling(source);
        return new TransactionAwareContextSourceProxy((ContextSource)configurePooling);
    }

    private PooledContextSource configurePooling(LdapContextSource source) {
        PoolConfig poolConfig = new PoolConfig();
        poolConfig.setTestOnBorrow(this.testOnBorrow.booleanValue());
        poolConfig.setTestWhileIdle(this.testWhileIdle.booleanValue());
        poolConfig.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis.longValue());
        poolConfig.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis.longValue());
        PooledContextSource pcs = new PooledContextSource(poolConfig);
        DefaultDirContextValidator defaultDirContextValidator = new DefaultDirContextValidator();
        pcs.setContextSource((ContextSource)source);
        pcs.setDirContextValidator((DirContextValidator)defaultDirContextValidator);
        return pcs;
    }

    @Bean(name={"ldapTemplate"})
    @Primary
    public LdapTemplate getLdapTemplate(TransactionAwareContextSourceProxy contextSource) {
        DefaultConversionService conversionService = new DefaultConversionService();
        conversionService.addConverter((Converter)new ConversionServiceConverterManager.StringToNameConverter());
        conversionService.addConverter((Converter)this.context.getBean(GeneralizedTimeToDate.class));
        conversionService.addConverter((Converter)this.context.getBean(DateToGeneralizedTime.class));
        ConversionServiceConverterManager converterManager = new ConversionServiceConverterManager((GenericConversionService)conversionService);
        DefaultObjectDirectoryMapper objectDirectoryMapper = new DefaultObjectDirectoryMapper();
        objectDirectoryMapper.setConverterManager((ConverterManager)converterManager);
        LdapTemplate ldapTemplate = new LdapTemplate((ContextSource)contextSource);
        ldapTemplate.setObjectDirectoryMapper((ObjectDirectoryMapper)objectDirectoryMapper);
        return ldapTemplate;
    }

    @Bean
    public ContextSourceTransactionManager getTxManager() {
        ContextSourceTransactionManager txManager = new ContextSourceTransactionManager();
        txManager.setContextSource((ContextSource)this.context.getBean("contextSourceTransactionAwareProxy"));
        txManager.setRenamingStrategy((TempEntryRenamingStrategy)new DefaultTempEntryRenamingStrategy());
        return txManager;
    }

    @Bean(name={"ldapTransactionManagerDelegate"})
    public ContextSourceTransactionManagerDelegate getTxManagerDelegate() {
        ContextSourceTransactionManagerDelegate txManagerDelegate = new ContextSourceTransactionManagerDelegate();
        txManagerDelegate.setContextSource((ContextSource)this.context.getBean("contextSourceTransactionAwareProxy"));
        return txManagerDelegate;
    }
}

