/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.tribu.api;

import fr.gouv.education.tribu.api.WsDevConfiguration;
import java.net.MalformedURLException;
import org.springframework.beans.BeansException;
import org.springframework.cache.CacheManager;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.cache.ehcache.EhCacheManagerFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

@Configuration
@Conditional(value={Condition.class})
@ImportResource(value={"api-users.xml"})
public class WsDevConfiguration
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    @Bean
    public EhCacheManagerFactoryBean cacheFactoryBean() throws MalformedURLException {
        EhCacheManagerFactoryBean ehCacheManagerFactoryBean = new EhCacheManagerFactoryBean();
        ehCacheManagerFactoryBean.setConfigLocation((Resource)new UrlResource("classpath:ehcache-replicated.xml"));
        return ehCacheManagerFactoryBean;
    }

    @Bean
    public CacheManager cacheManager() {
        EhCacheCacheManager cacheManager = new EhCacheCacheManager();
        EhCacheManagerFactoryBean cacheFactoryBean = (EhCacheManagerFactoryBean)this.applicationContext.getBean(EhCacheManagerFactoryBean.class);
        cacheManager.setCacheManager(cacheFactoryBean.getObject());
        return cacheManager;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

