/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.tribu.api;

import fr.gouv.education.tribu.api.WsProdConfiguration;
import java.net.MalformedURLException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.cache.ehcache.EhCacheManagerFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

@Configuration
@Conditional(value={Condition.class})
@ImportResource(value={"file:${catalina.base}/conf/api-users.xml"})
@PropertySource(value={"file:${catalina.base}/conf/application.properties"})
public class WsProdConfiguration
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    @Value(value="${catalina.home}")
    private String catalinaHome;

    @Bean
    public EhCacheManagerFactoryBean cacheFactoryBean() throws MalformedURLException {
        EhCacheManagerFactoryBean ehCacheManagerFactoryBean = new EhCacheManagerFactoryBean();
        ehCacheManagerFactoryBean.setConfigLocation((Resource)new UrlResource("file:" + this.catalinaHome + "/conf/ehcache-replicated.xml"));
        return ehCacheManagerFactoryBean;
    }

    @Bean
    public CacheManager cacheManager() {
        EhCacheCacheManager cacheManager = new EhCacheCacheManager();
        EhCacheManagerFactoryBean cacheFactoryBean = (EhCacheManagerFactoryBean)this.applicationContext.getBean(EhCacheManagerFactoryBean.class);
        cacheManager.setCacheManager(cacheFactoryBean.getObject());
        return cacheManager;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

