/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.tribu.api.controller;

import fr.gouv.education.tribu.api.controller.AbstractWsController;
import fr.gouv.education.tribu.api.controller.ContentErrorCode;
import fr.gouv.education.tribu.api.model.BinaryContent;
import fr.gouv.education.tribu.api.repo.RepositoryException;
import fr.gouv.education.tribu.api.service.ContentService;
import fr.gouv.education.tribu.api.service.UserNotFoundException;
import fr.gouv.education.tribu.api.service.token.DownloadToken;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/directdownload"})
@Api(value="Download")
public class DownloadController
extends AbstractWsController {
    private static final String DD = "/directdownload";
    @Autowired
    private ContentService contentService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="T\u00e9l\u00e9chargmeent direct")
    @ApiResponses(value={@ApiResponse(code=200, message="Ok"), @ApiResponse(code=204, message="Aucun r\u00e9sultat"), @ApiResponse(code=400, message="Erreur"), @ApiResponse(code=403, message="Non autoris\u00e9"), @ApiResponse(code=400, message="Erreur"), @ApiResponse(code=500, message="Erreur interne")})
    @RequestMapping(value={"/{uuid}"}, method={RequestMethod.GET})
    public ResponseEntity<String> getFile(@PathVariable(value="uuid") String uuid, @RequestParam(name="token") String token, HttpServletRequest request, HttpServletResponse response) throws IOException {
        long startTime = System.currentTimeMillis();
        DownloadToken tokenObject = this.contentService.checkToken(uuid, token);
        if (token == null || tokenObject == null) {
            return this.logAndReturn(null, DD, token, Long.valueOf(startTime), ContentErrorCode.WARN_BAD_TOKEN, new Object[0]);
        }
        ServletOutputStream output = response.getOutputStream();
        String userId = tokenObject.getUser();
        try {
            BinaryContent content = this.contentService.startDownload(uuid, userId);
            long lastModified = System.currentTimeMillis();
            response.setContentType(content.getMimeType());
            response.setHeader("Content-Disposition", "attachment; filename=\"" + content.getFileName() + "\"");
            response.setHeader("Content-Length", String.valueOf(content.getCount()));
            response.setDateHeader("Last-Modified", lastModified);
            FileInputStream in = new FileInputStream(content.getTempFile());
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)output, 4096);
            try {
                byte[] b = new byte[4096];
                int i = -1;
                while ((i = ((InputStream)in).read(b)) != -1) {
                    out.write(b, 0, i);
                }
                out.flush();
            }
            finally {
                IOUtils.closeQuietly((Closeable)in);
                IOUtils.closeQuietly((Closeable)out);
            }
        }
        catch (UserNotFoundException e) {
            return this.logAndReturn(null, DD, tokenObject.getUser() + "@" + tokenObject.getAppId(), Long.valueOf(startTime), ContentErrorCode.WARN_WRONG_USER, new Object[0]);
        }
        catch (RepositoryException e) {
            return this.logAndReturn(null, DD, tokenObject.getUser() + "@" + tokenObject.getAppId(), Long.valueOf(startTime), ContentErrorCode.ERROR_BACKEND, new Object[0]);
        }
        return this.logAndReturn(null, DD, tokenObject.getUser() + "@" + tokenObject.getAppId(), Long.valueOf(startTime), ContentErrorCode.INFO_OK, new Object[0]);
    }
}

