/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.tribu.api.controller;

import fr.gouv.education.tribu.api.controller.AbstractWsController;
import fr.gouv.education.tribu.api.controller.ContentErrorCode;
import fr.gouv.education.tribu.api.model.AbstractResponse;
import fr.gouv.education.tribu.api.model.DownloadForm;
import fr.gouv.education.tribu.api.model.DownloadUrlResponse;
import fr.gouv.education.tribu.api.model.SearchForm;
import fr.gouv.education.tribu.api.model.TribuApiResponse;
import fr.gouv.education.tribu.api.repo.RepositoryException;
import fr.gouv.education.tribu.api.service.ContentService;
import fr.gouv.education.tribu.api.service.ContentServiceException;
import fr.gouv.education.tribu.api.service.UserNotFoundException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/contents"})
@Api(value="Contents")
public class SearchController
extends AbstractWsController {
    protected static final String CONTEXTE = "/contents";
    private static final String SEARCH = "/contents/search";
    private static final String DOWNLOAD = "/contents/download";
    @Autowired
    private ContentService contentService;

    @ApiOperation(value="Recherche de documents", response=TribuApiResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Recherche ok"), @ApiResponse(code=204, message="Aucun r\u00e9sultat"), @ApiResponse(code=400, message="Erreur"), @ApiResponse(code=403, message="Non autoris\u00e9"), @ApiResponse(code=400, message="Erreur"), @ApiResponse(code=500, message="Erreur interne")})
    @PostMapping(value={"/search/"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<String> search(@RequestBody SearchForm search) {
        TribuApiResponse liste;
        long startTime = System.currentTimeMillis();
        if (search == null) {
            return this.logAndReturn(null, SEARCH, "?", Long.valueOf(startTime), ContentErrorCode.WARN_WRONG_PARAMETER, new Object[]{"search"});
        }
        if (StringUtils.isBlank((CharSequence)search.getUser()) || StringUtils.isBlank((CharSequence)search.getAppId())) {
            return this.logAndReturn(null, SEARCH, "?", Long.valueOf(startTime), ContentErrorCode.WARN_WRONG_PARAMETER, new Object[]{"user et appId"});
        }
        if (search.getTitle() == null && search.getFulltext() == null) {
            return this.logAndReturn(null, SEARCH, search.getUser(), Long.valueOf(startTime), ContentErrorCode.WARN_WRONG_PARAMETER, new Object[]{"titre ou fulltext"});
        }
        String logUser = search.getAppId() + "/" + search.getUser();
        try {
            liste = this.contentService.search(search);
        }
        catch (UserNotFoundException e) {
            return this.logStackAndReturn((Exception)((Object)e), SEARCH, logUser, Long.valueOf(startTime), ContentErrorCode.WARN_WRONG_USER, new Object[0]);
        }
        catch (RepositoryException e) {
            return this.logStackAndReturn((Exception)((Object)e), SEARCH, logUser, Long.valueOf(startTime), ContentErrorCode.ERROR_BACKEND, new Object[0]);
        }
        catch (ContentServiceException e) {
            return this.logStackAndReturn((Exception)((Object)e), SEARCH, logUser, Long.valueOf(startTime), ContentErrorCode.ERROR_TECH, new Object[0]);
        }
        return this.logAndReturn((AbstractResponse)liste, SEARCH, logUser, Long.valueOf(startTime), ContentErrorCode.INFO_OK, new Object[0]);
    }

    @ApiOperation(value="Demande t\u00e9l\u00e9chargement de documents", response=DownloadUrlResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Recherche ok"), @ApiResponse(code=403, message="Non autoris\u00e9"), @ApiResponse(code=404, message="Document non trouv\u00e9"), @ApiResponse(code=400, message="Erreur"), @ApiResponse(code=400, message="Erreur"), @ApiResponse(code=500, message="Erreur interne")})
    @PostMapping(value={"/download/"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<String> download(@RequestBody DownloadForm dlForm) {
        DownloadUrlResponse url;
        long startTime = System.currentTimeMillis();
        if (dlForm == null) {
            return this.logAndReturn(null, DOWNLOAD, "?", Long.valueOf(startTime), ContentErrorCode.WARN_WRONG_PARAMETER, new Object[]{"search"});
        }
        if (StringUtils.isBlank((CharSequence)dlForm.getUser()) || StringUtils.isBlank((CharSequence)dlForm.getAppId())) {
            return this.logAndReturn(null, SEARCH, "?", Long.valueOf(startTime), ContentErrorCode.WARN_WRONG_PARAMETER, new Object[]{"user et appId"});
        }
        if (dlForm.getUuid() == null && dlForm.getUuid() == null) {
            return this.logAndReturn(null, DOWNLOAD, dlForm.getUser(), Long.valueOf(startTime), ContentErrorCode.WARN_WRONG_PARAMETER, new Object[]{"uuid"});
        }
        String logUser = dlForm.getAppId() + "/" + dlForm.getUser();
        try {
            url = this.contentService.download(dlForm);
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (UserNotFoundException e) {
            return this.logStackAndReturn((Exception)((Object)e), SEARCH, logUser, Long.valueOf(startTime), ContentErrorCode.WARN_WRONG_USER, new Object[0]);
        }
        catch (RepositoryException e) {
            return this.logStackAndReturn((Exception)((Object)e), DOWNLOAD, logUser, Long.valueOf(startTime), ContentErrorCode.ERROR_BACKEND, new Object[0]);
        }
        catch (ContentServiceException e) {
            return this.logStackAndReturn((Exception)((Object)e), DOWNLOAD, logUser, Long.valueOf(startTime), ContentErrorCode.ERROR_TECH, new Object[0]);
        }
        catch (InterruptedException e) {
            return this.logStackAndReturn((Exception)e, DOWNLOAD, logUser, Long.valueOf(startTime), ContentErrorCode.ERROR_TECH, new Object[0]);
        }
        return this.logAndReturn((AbstractResponse)url, DOWNLOAD, logUser, Long.valueOf(startTime), ContentErrorCode.INFO_OK, new Object[0]);
    }
}

