/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.tribu.api.directory.dao;

import fr.gouv.education.tribu.api.directory.dao.MappingHelper;
import fr.gouv.education.tribu.api.directory.dao.PersonDao;
import fr.gouv.education.tribu.api.directory.model.Person;
import java.util.List;
import javax.naming.Name;
import javax.naming.directory.SearchControls;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.OrFilter;
import org.springframework.ldap.support.LdapNameBuilder;
import org.springframework.stereotype.Repository;

@Repository(value="personDao")
public class PersonDaoImpl
implements PersonDao {
    @Value(value="${ldap.base:dc=osivia,dc=org}")
    private String base;
    @Value(value="${ldap.searchperson.maxTime:5000}")
    private int searchTimeLimit;
    @Value(value="${ldap.searchperson.maxResults:750}")
    private int searchMaxResults;
    @Autowired
    protected Person sample;
    @Autowired
    @Qualifier(value="ldapTemplate")
    protected LdapTemplate template;
    private SearchControls controls;

    public Name buildBaseDn() {
        return LdapNameBuilder.newInstance((String)this.base).add("ou=users").build();
    }

    public Name buildDn(String uid) {
        return LdapNameBuilder.newInstance((Name)this.buildBaseDn()).add("uid=" + uid).build();
    }

    public List<Person> findByCriteria(Person p) {
        OrFilter filter = MappingHelper.generateOrFilter((Object)p);
        return this.template.find(this.buildBaseDn(), (Filter)filter, this.getSearchControls(), this.sample.getClass());
    }

    protected SearchControls getSearchControls() {
        if (this.controls == null) {
            this.controls = new SearchControls();
            this.controls.setSearchScope(1);
            this.controls.setTimeLimit(this.searchTimeLimit);
            this.controls.setCountLimit(this.searchMaxResults);
        }
        return this.controls;
    }
}

