/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.tribu.api.model;

import fr.gouv.education.tribu.api.service.ContentServiceException;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.nuxeo.ecm.automation.client.model.Document;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="ContentDto")
@Scope(value="prototype")
@ApiModel
public class ContentDto {
    public static final String COMPONENT_NAME = "ContentDto";
    @Value(value="${portal.url}")
    private String portalUrl;
    private static final String PORTAL_CMS_PATH = "/cms";
    @ApiModelProperty(value="Identifiant nuxeo", example="a5fcbab0-6069-4bcf-813f-08c56f48a0ea")
    private String uuid;
    @ApiModelProperty(value="Titre du document", example="Rapport d'activit\u00e9")
    private String title;
    @ApiModelProperty(value="Description du document", example="Rapport d'activit\u00e9 de la r\u00e9union du 16-07")
    private String description;
    @ApiModelProperty(value="Auteur du document", example="Jacques Dupont")
    public String creator;
    @ApiModelProperty(value="Date de modification", example="2020-07-24T12:37:56.983Z")
    public Date modified;
    @ApiModelProperty(value="Date de cr\u00e9ation", example="2020-07-24T12:37:56.983Z")
    public Date created;
    @ApiModelProperty(value="Dernier contributeur sur le document", example="Jacques Dupont")
    public String lastContributor;
    @ApiModelProperty(value="Date de publication", example="2020-07-24T12:37:56.983Z")
    public Date issued;
    @ApiModelProperty(value="Titre de l'espace contenant le document", example="Espace de modernisation")
    public String spaceTitle;
    @ApiModelProperty(value="Permalien vers tribu", example="https://tribu.phm.education.gouv.fr/portal/share/guide-tribu")
    private String url;
    @ApiModelProperty(value="Propri\u00e9t\u00e9s nuxeo du document")
    private Map<String, Object> properties = new LinkedHashMap();

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPortalUrl() {
        return this.portalUrl;
    }

    public void setPortalUrl(String portalUrl) {
        this.portalUrl = portalUrl;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public String getLastContributor() {
        return this.lastContributor;
    }

    public void setLastContributor(String lastContributor) {
        this.lastContributor = lastContributor;
    }

    public Date getIssued() {
        return this.issued;
    }

    public void setIssued(Date issued) {
        this.issued = issued;
    }

    public String getSpaceTitle() {
        return this.spaceTitle;
    }

    public void setSpaceTitle(String spaceTitle) {
        this.spaceTitle = spaceTitle;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public static String getComponentName() {
        return COMPONENT_NAME;
    }

    public static String getPortalCmsPath() {
        return PORTAL_CMS_PATH;
    }

    public ContentDto toDto(Document document) throws ContentServiceException {
        URL url;
        this.setTitle(document.getTitle());
        this.setUuid(document.getId());
        this.setCreated(document.getProperties().getDate("dc:created"));
        this.setCreator(document.getProperties().getString("dc:creator"));
        this.setDescription(document.getProperties().getString("dc:description"));
        this.setIssued(document.getDate("dc:issued"));
        this.setLastContributor(document.getProperties().getString("dc:lastContributor"));
        this.setModified(document.getProperties().getDate("dc:modified"));
        this.setSpaceTitle(document.getProperties().getString("ttc:spaceTitle"));
        this.properties = document.getProperties().map();
        String path = document.getPath();
        try {
            url = new URL(this.portalUrl + PORTAL_CMS_PATH + path);
        }
        catch (MalformedURLException e) {
            throw new ContentServiceException("malformed portal URL", (Exception)e);
        }
        this.setUrl(url.toString());
        return this;
    }
}

