/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.tribu.api.model;

import fr.gouv.education.tribu.api.model.AbstractResponse;
import fr.gouv.education.tribu.api.model.ContentDto;
import fr.gouv.education.tribu.api.service.ContentServiceException;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@ApiModel
public class DownloadUrlResponse
extends AbstractResponse {
    private static final String SERVLET_PATH = "/directdownload/";
    @Value(value="${api.url}")
    private String apiUrl;
    @ApiModelProperty(value="URL de t\u00e9l\u00e9chargement \u00e9ph\u00e9m\u00e8re, avec param\u00e8tre du jeton", example="https://tribu-api.in.phm.education.gouv.fr/tribu-api/directdownload/a5fcbab0-6069-4bcf-813f-08c56f48a0ea?token=123456vUsfkok")
    private String directDownloadUrl;
    @ApiModelProperty(value="Jeton de t\u00e9l\u00e9chargement contenu dans l'url", example="123456vUsfkok")
    private String token;

    public DownloadUrlResponse(List<ContentDto> contents) {
        super(contents);
    }

    public String getDirectDownloadUrl() {
        return this.directDownloadUrl;
    }

    public String getToken() {
        return this.token;
    }

    public DownloadUrlResponse toResponse(String token) throws ContentServiceException {
        try {
            this.token = token;
            URL url = new URL(this.apiUrl + SERVLET_PATH + ((ContentDto)this.getContents().get(0)).getUuid() + "?token=" + token);
            this.directDownloadUrl = url.toString();
            return this;
        }
        catch (MalformedURLException e) {
            throw new ContentServiceException("malformed url exception", (Exception)e);
        }
    }
}

