/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.tribu.api.repo;

import fr.gouv.education.tribu.api.repo.RepositoryException;
import fr.gouv.education.tribu.api.repo.commands.TestNxCommand;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.jaxrs.impl.HttpAutomationClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository
public class NuxeoPoolFactory
implements PooledObjectFactory<HttpAutomationClient> {
    public static final String NUXEO_CONTEXT = "/nuxeo";
    @Value(value="${nuxeo.privateHost}")
    private String host;
    @Value(value="${nuxeo.privatePort}")
    private String port;

    public PooledObject<HttpAutomationClient> makeObject() throws Exception {
        String url = this.getPrivateBaseUri().toString() + "/site/automation";
        HttpAutomationClient client = new HttpAutomationClient(url);
        DefaultPooledObject pooled = new DefaultPooledObject((Object)client);
        return pooled;
    }

    public void destroyObject(PooledObject<HttpAutomationClient> p) throws Exception {
        HttpAutomationClient client = (HttpAutomationClient)p.getObject();
        client.shutdown();
    }

    public boolean validateObject(PooledObject<HttpAutomationClient> p) {
        HttpAutomationClient client = (HttpAutomationClient)p.getObject();
        Session session = client.getSession();
        TestNxCommand test = new TestNxCommand();
        try {
            test.execute(session);
        }
        catch (RepositoryException e) {
            return false;
        }
        return true;
    }

    public void activateObject(PooledObject<HttpAutomationClient> p) throws Exception {
    }

    public void passivateObject(PooledObject<HttpAutomationClient> p) throws Exception {
    }

    public final URI getPrivateBaseUri() throws URISyntaxException {
        return new URI("http://" + this.host + ":" + this.port + NUXEO_CONTEXT);
    }
}

