/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.tribu.api.repo;

import fr.gouv.education.tribu.api.model.TribuApiQueryForm;
import fr.gouv.education.tribu.api.repo.NuxeoCommand;
import fr.gouv.education.tribu.api.repo.RepositoryException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Documents;

public abstract class NuxeoQueryCommand
implements NuxeoCommand {
    protected static final Log LOGGER = LogFactory.getLog((String)"tribu-queries");
    protected static final String LOG_SEPARATOR = " ";
    private static final String DEFAULT_SCHEMAS = "dublincore,toutatice";
    private static final Integer DEFAULT_PAGESIZE = 25;
    private final Integer pageSize;
    private final Integer pageNumber;

    public NuxeoQueryCommand() {
        this.pageSize = DEFAULT_PAGESIZE;
        this.pageNumber = 0;
    }

    public NuxeoQueryCommand(TribuApiQueryForm form) {
        this.pageSize = form.getPageSize() != null ? form.getPageSize() : DEFAULT_PAGESIZE;
        this.pageNumber = form.getPageNumber() != null ? form.getPageNumber() : Integer.valueOf(0);
    }

    public Object execute(Session nuxeoSession) throws RepositoryException {
        Object objects;
        try {
            OperationRequest request = nuxeoSession.newRequest("Document.QueryES");
            request.setHeader("X-NXDocumentProperties", this.getDocumentProperties());
            request.set("query", (Object)this.getQuery().toString());
            request.set("pageSize", (Object)this.getPageSize());
            request.set("currentPageIndex", (Object)this.getPageNumber());
            long startTime = System.currentTimeMillis();
            objects = request.execute();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.logMsg(request, objects, startTime));
            }
        }
        catch (Exception e) {
            throw new RepositoryException("original request from " + this.getClass().getSimpleName() + " : " + this.getQuery().toString(), e);
        }
        return objects;
    }

    protected abstract StringBuilder getQuery();

    protected String getDocumentProperties() {
        return DEFAULT_SCHEMAS;
    }

    protected Integer getPageSize() {
        return this.pageSize;
    }

    protected Integer getPageNumber() {
        return this.pageNumber;
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        return builder.toString();
    }

    private String logMsg(OperationRequest request, Object objects, long startTime) {
        long stopTime = System.currentTimeMillis();
        long elapsedTime = stopTime - startTime;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getId());
        sb.append(LOG_SEPARATOR);
        sb.append("user=");
        sb.append(request.getSession().getLogin().getUsername());
        sb.append(LOG_SEPARATOR);
        sb.append(request.getHeaders());
        sb.append(LOG_SEPARATOR);
        sb.append(request.getParameters());
        sb.append(LOG_SEPARATOR);
        sb.append(objects);
        if (objects instanceof Documents) {
            sb.append(LOG_SEPARATOR);
            Documents docs = (Documents)objects;
            sb.append("resultCount=");
            sb.append(docs.size());
        }
        sb.append(LOG_SEPARATOR);
        sb.append("elasped=");
        sb.append(elapsedTime);
        return sb.toString();
    }
}

