/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.tribu.api.repo;

import fr.gouv.education.tribu.api.repo.NuxeoCommand;
import fr.gouv.education.tribu.api.repo.NuxeoRepo;
import fr.gouv.education.tribu.api.repo.RepositoryException;
import fr.gouv.education.tribu.api.service.UserNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.jaxrs.impl.HttpAutomationClient;
import org.nuxeo.ecm.automation.client.jaxrs.spi.RequestInterceptor;
import org.nuxeo.ecm.automation.client.jaxrs.spi.auth.PortalSSOAuthInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class NuxeoRepoImpl
implements NuxeoRepo {
    private final Log log = LogFactory.getLog((String)NuxeoRepoImpl.class.getName());
    @Value(value="${nuxeo.secretKey}")
    private String secretKey;
    @Autowired
    private GenericObjectPool<HttpAutomationClient> pool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeCommand(String userId, NuxeoCommand command) throws RepositoryException, UserNotFoundException {
        HttpAutomationClient client = null;
        if (userId == null) {
            throw new RepositoryException("Unable to get a valid user " + userId);
        }
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("About to get a connexion from the pool. Idle : " + this.pool.getNumIdle() + ", active : " + this.pool.getNumActive() + ", waiters : " + this.pool.getNumWaiters()));
            }
            client = (HttpAutomationClient)this.pool.borrowObject();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Got connexion from the pool " + client.hashCode() + ". Idle : " + this.pool.getNumIdle() + ", active : " + this.pool.getNumActive() + ", waiters : " + this.pool.getNumWaiters()));
            }
        }
        catch (Exception e) {
            throw new RepositoryException("Unable to get a connection to nuxeo from the pool", e);
        }
        try {
            Object object;
            Session session;
            if (userId != null) {
                client.setRequestInterceptor((RequestInterceptor)new PortalSSOAuthInterceptor(this.secretKey, userId));
            }
            try {
                session = client.getSession();
            }
            catch (Exception e) {
                throw new UserNotFoundException("Unable to login with " + userId, e);
            }
            Object object2 = object = command.execute(session);
            return object2;
        }
        finally {
            this.pool.returnObject((Object)client);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Release connexion to the pool. Idle : " + this.pool.getNumIdle() + ", active : " + this.pool.getNumActive() + ", waiters : " + this.pool.getNumWaiters()));
            }
        }
    }
}

