/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.tribu.api.repo.commands;

import com.google.common.io.CountingOutputStream;
import fr.gouv.education.tribu.api.model.BinaryContent;
import fr.gouv.education.tribu.api.repo.NuxeoCommand;
import fr.gouv.education.tribu.api.repo.RepositoryException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.OperationInput;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class FileContentCommand
implements NuxeoCommand {
    public static final String PDF_CONTENT = "pdf:content";
    public static final String PDF_CONVERSION_ERROR = "errorOnPdfConversion";
    Document document;
    String docPath;
    String fieldName;
    String timestamp;

    public FileContentCommand(String docUuid) {
        this.docPath = docUuid;
        this.fieldName = "file:content";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Session session) throws RepositoryException {
        try {
            if (this.document == null) {
                this.document = (Document)session.newRequest("Document.Fetch").setHeader("X-NXDocumentProperties", "*").set("value", (Object)this.docPath).execute();
            }
            String[] tokens = this.fieldName.split("/");
            boolean pdfConversion = false;
            if (PDF_CONTENT.equals(tokens[0])) {
                tokens[0] = "file:content";
                pdfConversion = true;
            }
            PropertyMap map = this.document.getProperties().getMap(tokens[0]);
            for (int i = 1; i < tokens.length; ++i) {
                map = map.getMap(tokens[i]);
            }
            String pathFile = map.getString("data");
            FileBlob blob = pdfConversion ? (FileBlob)session.newRequest("Blob.AnyToPDF").setInput((OperationInput)this.document).execute() : (FileBlob)session.getFile(pathFile);
            FileInputStream in = new FileInputStream(blob.getFile());
            File tempFile = File.createTempFile("tempFile", ".tmp");
            tempFile.deleteOnExit();
            CountingOutputStream cout = new CountingOutputStream((OutputStream)new FileOutputStream(tempFile));
            try {
                byte[] b = new byte[1000000];
                int i = -1;
                while ((i = ((InputStream)in).read(b)) != -1) {
                    cout.write(b, 0, i);
                }
                cout.flush();
            }
            finally {
                IOUtils.closeQuietly((Closeable)in);
                IOUtils.closeQuietly((Closeable)cout);
            }
            blob.getFile().delete();
            BinaryContent content = new BinaryContent();
            String fileName = blob.getFileName();
            if (fileName == null || "null".equals(fileName)) {
                fileName = this.document.getTitle();
            }
            content.setName(fileName);
            content.setFile(tempFile);
            content.setMimeType(blob.getMimeType());
            content.setFileSize(cout.getCount());
            return content;
        }
        catch (Exception e) {
            throw new RepositoryException(e);
        }
    }

    public String getId() {
        String id = "FileContentCommand";
        id = this.document == null ? id + this.docPath : id + this.document;
        if (this.timestamp != null) {
            id = id + this.timestamp;
        }
        id = id + "/" + this.fieldName;
        return id;
    }
}

