/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.tribu.api.repo.commands;

import fr.gouv.education.tribu.api.model.SearchForm;
import fr.gouv.education.tribu.api.model.TribuApiQueryForm;
import fr.gouv.education.tribu.api.repo.NuxeoQueryCommand;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class SearchCommand
extends NuxeoQueryCommand {
    private static final String BACKEND_DATE_PATTERN = "yyyy-MM-dd";
    private SearchForm search;
    private String workspacePath;

    public SearchCommand(SearchForm search, String workspacePath) {
        super((TribuApiQueryForm)search);
        this.search = search;
        this.workspacePath = workspacePath;
    }

    protected StringBuilder getQuery() {
        String keyWord;
        Iterator<String> itKeyWords;
        String[] keyWds;
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM Document WHERE ");
        query.append(" ecm:mixinType <> 'HiddenInNavigation' AND ecm:currentLifeCycleState <> 'deleted'  AND ecm:isCheckedInVersion = 0");
        query.append(" AND (ecm:mixinType = 'Downloadable' OR ecm:mixinType = 'Audio' OR ecm:mixinType = 'Video' OR ecm:mixinType = 'Picture' ) ");
        query.append(" AND ecm:mixinType <> 'isLocalPublishLive' ");
        if (StringUtils.isNotBlank((CharSequence)this.search.getFulltext())) {
            query.append(" AND ");
            String searchStr = Normalizer.normalize(this.search.getFulltext(), Normalizer.Form.NFD);
            searchStr = searchStr.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
            searchStr = searchStr.replaceAll("[^A-Za-z0-9 ]", " ");
            keyWds = StringUtils.split((String)searchStr);
            itKeyWords = Arrays.asList(keyWds).iterator();
            while (itKeyWords.hasNext()) {
                keyWord = itKeyWords.next();
                query.append("(ecm:fulltext = '");
                query.append(keyWord);
                query.append("' OR dc:title ILIKE '%");
                query.append(keyWord);
                query.append("%')");
                if (!itKeyWords.hasNext()) continue;
                query.append(" AND ");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.search.getTitle())) {
            query.append(" AND ");
            String titleStr = Normalizer.normalize(this.search.getTitle(), Normalizer.Form.NFD);
            titleStr = titleStr.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
            titleStr = titleStr.replaceAll("[^A-Za-z0-9 ]", " ");
            keyWds = StringUtils.split((String)titleStr);
            itKeyWords = Arrays.asList(keyWds).iterator();
            while (itKeyWords.hasNext()) {
                keyWord = itKeyWords.next();
                query.append("dc:title ILIKE '%");
                query.append(keyWord);
                query.append("%'");
                if (!itKeyWords.hasNext()) continue;
                query.append(" AND ");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.workspacePath)) {
            query.append(" AND ecm:path STARTSWITH '" + this.workspacePath + "' ");
        }
        if (this.search.getModificationBeginDate() != null && this.search.getModificationEndDate() != null) {
            String from = DateFormatUtils.format((Date)this.search.getModificationBeginDate(), (String)BACKEND_DATE_PATTERN);
            Date endDate = DateUtils.addDays((Date)this.search.getModificationEndDate(), (int)1);
            String to = DateFormatUtils.format((Date)endDate, (String)BACKEND_DATE_PATTERN);
            query.append(" AND (dc:modified BETWEEN DATE '");
            query.append(from);
            query.append("' AND DATE '");
            query.append(to);
            query.append("') ");
        }
        if (this.search.getSort() != null && StringUtils.isNotEmpty((CharSequence)this.search.getSort().getOrderBy())) {
            query.append("ORDER BY ");
            query.append(this.search.getSort().getOrderBy());
            if (BooleanUtils.isTrue((Boolean)this.search.getReversedSort())) {
                query.append(" DESC");
            } else {
                query.append(" ASC");
            }
        }
        return query;
    }

    protected String getDocumentProperties() {
        return "*";
    }
}

