/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.tribu.api.security;

import fr.gouv.education.tribu.api.controller.ContentErrorCode;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;

public class APIKeyAuthFilter
extends AbstractPreAuthenticatedProcessingFilter {
    protected static final Log LOGGER = LogFactory.getLog((String)"tribu.api");
    private String principalRequestHeader;

    public APIKeyAuthFilter(String principalRequestHeader) {
        this.principalRequestHeader = principalRequestHeader;
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        String header = request.getHeader(this.principalRequestHeader);
        if (header == null) {
            LOGGER.warn((Object)(ContentErrorCode.WARN_MISSING_APIKEY.getCode() + " " + ContentErrorCode.WARN_MISSING_APIKEY.getMessage()));
        }
        return header;
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return "N/A";
    }
}

