/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.tribu.api.security;

import fr.gouv.education.tribu.api.controller.ContentErrorCode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class APIKeyAuthenticationManager
implements AuthenticationManager {
    protected static final Log LOGGER = LogFactory.getLog((String)"tribu.api");
    private String principalRequestValue;

    public APIKeyAuthenticationManager(String principalRequestValue) {
        this.principalRequestValue = principalRequestValue;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String principal = (String)authentication.getPrincipal();
        if (!this.principalRequestValue.equals(principal)) {
            LOGGER.warn((Object)(ContentErrorCode.WARN_APIKEY.getCode() + " " + ContentErrorCode.WARN_APIKEY.getMessage()));
            throw new BadCredentialsException("The API key was not found or not the expected value.");
        }
        authentication.setAuthenticated(true);
        return authentication;
    }
}

