/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.customizer.feeder;

import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.directory.v2.service.PersonUpdateService;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.customization.CustomizationModuleMetadatas;
import org.osivia.portal.api.customization.ICustomizationModule;
import org.osivia.portal.api.customization.ICustomizationModulesRepository;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Person;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class FeederCustomizer
extends GenericPortlet
implements ICustomizationModule {
    private static final String CUSTOMIZER_NAME = "foad.customizer.feeder";
    private static final String ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY = "CustomizationModulesRepository";
    private static final String CAS_ATTRIBUTE_PREFIX = "cas:";
    private ICustomizationModulesRepository repository;
    private final CustomizationModuleMetadatas metadatas = this.generateMetadatas();
    protected static Log logger = LogFactory.getLog(FeederCustomizer.class);

    private CustomizationModuleMetadatas generateMetadatas() {
        CustomizationModuleMetadatas metadatas = new CustomizationModuleMetadatas();
        metadatas.setName(CUSTOMIZER_NAME);
        metadatas.setModule((ICustomizationModule)this);
        metadatas.setCustomizationIDs(Arrays.asList("osivia.customizer.feeder.id"));
        return metadatas;
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        this.repository = (ICustomizationModulesRepository)this.getPortletContext().getAttribute(ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY);
        this.repository.register(this.metadatas);
    }

    public void destroy() {
        super.destroy();
        this.repository.unregister(this.metadatas);
    }

    public void customize(String customizationID, CustomizationContext context) {
        try {
            PersonUpdateService service;
            Node casAttributes;
            Map attributes = context.getAttributes();
            HttpServletRequest request = (HttpServletRequest)attributes.get("request");
            String response = (String)request.getAttribute("casresponse");
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(new InputSource(new StringReader(response)));
            Element authentication = (Element)doc.getElementsByTagName("cas:serviceResponse").item(0);
            String userId = "";
            HashMap<String, String> personAttributes = new HashMap<String, String>();
            userId = authentication.getElementsByTagName("cas:user").item(0).getTextContent();
            NodeList casAttributesList = authentication.getElementsByTagName("cas:attributes");
            if (casAttributesList != null && (casAttributes = casAttributesList.item(0)) != null) {
                for (int i = 0; i < casAttributes.getChildNodes().getLength(); ++i) {
                    String attributeName;
                    Node casAttribute = casAttributes.getChildNodes().item(i);
                    if (casAttribute.getNodeType() != 1 || !(attributeName = casAttribute.getNodeName()).startsWith(CAS_ATTRIBUTE_PREFIX)) continue;
                    personAttributes.put(attributeName.substring(CAS_ATTRIBUTE_PREFIX.length()), casAttribute.getTextContent());
                }
            }
            if ((service = (PersonUpdateService)DirServiceFactory.getService(PersonUpdateService.class)) != null) {
                Person p = service.getPerson(userId);
                if (p == null) {
                    p = service.getEmptyPerson();
                    p.setCn(userId);
                    p.setUid(userId);
                    p.setSn((String)personAttributes.get("sn"));
                    p.setCn((String)personAttributes.get("cn"));
                    p.setDisplayName((String)personAttributes.get("displayName"));
                    p.setMail((String)personAttributes.get("mail"));
                    p.setGivenName((String)personAttributes.get("givenName"));
                    service.create(p);
                } else {
                    if (personAttributes.size() > 0) {
                        if (personAttributes.get("sn") != null) {
                            p.setSn((String)personAttributes.get("sn"));
                        }
                        if (personAttributes.get("cn") != null) {
                            p.setCn((String)personAttributes.get("cn"));
                        }
                        if (personAttributes.get("displayName") != null) {
                            p.setDisplayName((String)personAttributes.get("displayName"));
                        }
                        if (personAttributes.get("mail") != null) {
                            p.setMail((String)personAttributes.get("mail"));
                        }
                        if (personAttributes.get("givenName") != null) {
                            p.setGivenName((String)personAttributes.get("givenName"));
                        }
                    }
                    service.update(p);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

