/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.customizer.attributes;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.ControllerException;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.command.render.RenderPageCommand;
import org.jboss.portal.core.theme.PageRendition;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.theming.IAttributesBundle;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSObjectPath;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;

public class CustomizedAttributesBundle
implements IAttributesBundle {
    private static final String FIM_URL_RETOUR = "freduurlretour";
    private static final String APPLICATIONS = "osivia.sso.applications";
    private static final String TOOLBAR_HELP_URL = "toolbar.help.url";
    private static final String STATS_SERVER_URL = "stats.server.url";
    private static final String STATS_SERVER_SITEID = "stats.server.siteid";
    private static final String STATS_DIM_SPACEID = "stats.dim.spaceid";
    private static final String STATS_DIM_SPACETITLE = "stats.dim.spacetitle";
    private static final String SPACE_TITLE = "stats.space.title";
    private static final String SPACE_ID = "stats.space.id";
    private static final IAttributesBundle INSTANCE = new CustomizedAttributesBundle();
    private final Set<String> names = new HashSet();
    private final List<String> applications;
    private final IPortalUrlFactory portalUrlFactory;
    private final ICMSServiceLocator cmsServiceLocator;

    private CustomizedAttributesBundle() {
        this.names.add(APPLICATIONS);
        this.names.add(TOOLBAR_HELP_URL);
        this.names.add(STATS_SERVER_URL);
        this.names.add(STATS_SERVER_SITEID);
        this.names.add(STATS_DIM_SPACEID);
        this.names.add(STATS_DIM_SPACETITLE);
        this.names.add(SPACE_TITLE);
        this.names.add(SPACE_ID);
        this.applications = new ArrayList();
        this.applications.add(NuxeoConnectionProperties.getPublicBaseUri().toString().concat("/logout"));
        this.applications.add(System.getProperty("cas.logout"));
        this.portalUrlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
        this.cmsServiceLocator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");
    }

    public static IAttributesBundle getInstance() {
        return INSTANCE;
    }

    public void fill(RenderPageCommand renderPageCommand, PageRendition pageRendition, Map<String, Object> attributes) throws ControllerException {
        String helpUrl;
        String headerUrlRetour;
        ControllerContext controllerContext = renderPageCommand.getControllerContext();
        PortalControllerContext portalControllerContext = new PortalControllerContext((Object)controllerContext);
        ArrayList<String> applisToLogout = new ArrayList<String>(this.applications);
        if (portalControllerContext != null && portalControllerContext.getHttpServletRequest() != null && StringUtils.isNotBlank((String)(headerUrlRetour = portalControllerContext.getHttpServletRequest().getHeader(FIM_URL_RETOUR)))) {
            String portalLogout = (String)attributes.get("osivia.toolbar.signOutURL");
            applisToLogout.add(portalLogout);
            attributes.put("osivia.toolbar.signOutURL", headerUrlRetour);
        }
        attributes.put(APPLICATIONS, applisToLogout);
        String helpPath = System.getProperty("help.path");
        if (StringUtils.isBlank((String)helpPath)) {
            helpUrl = null;
        } else {
            if (!StringUtils.startsWith((String)helpPath, (String)"/")) {
                helpPath = NuxeoController.webIdToCmsPath((String)helpPath);
            }
            helpUrl = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, helpPath, null, null, null, null, null, null, null);
        }
        attributes.put(TOOLBAR_HELP_URL, helpUrl);
        this.computeStatistics(renderPageCommand, attributes);
    }

    private void computeStatistics(RenderPageCommand renderPageCommand, Map<String, Object> attributes) throws ControllerException {
        String spaceId;
        String spaceTitle;
        Document document;
        ControllerContext controllerContext = renderPageCommand.getControllerContext();
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setControllerContext(controllerContext);
        Page page = renderPageCommand.getPage();
        String basePath = page.getProperty("osivia.cms.basePath");
        CMSItem cmsItem = null;
        if (StringUtils.isNotEmpty((String)basePath)) {
            String path = basePath;
            try {
                cmsItem = cmsService.getSpaceConfig(cmsContext, path);
                DocumentType type = cmsItem.getType();
                while (type != null && !type.isRootType()) {
                    CMSObjectPath parent = CMSObjectPath.parse((String)path).getParent();
                    path = parent.toString();
                    cmsItem = cmsService.getSpaceConfig(cmsContext, path);
                    type = cmsItem.getType();
                }
            }
            catch (CMSException parent) {
                // empty catch block
            }
        }
        if ((document = cmsItem != null && cmsItem.getNativeItem() instanceof Document ? (Document)cmsItem.getNativeItem() : null) == null) {
            spaceTitle = null;
            spaceId = null;
        } else {
            spaceTitle = document.getTitle();
            spaceId = document.getString("webc:url");
        }
        attributes.put(SPACE_TITLE, spaceTitle);
        attributes.put(SPACE_ID, spaceId);
        if (StringUtils.isNotBlank((String)System.getProperty(STATS_SERVER_URL))) {
            attributes.put(STATS_SERVER_URL, System.getProperty(STATS_SERVER_URL));
        }
        if (StringUtils.isNotBlank((String)System.getProperty(STATS_SERVER_SITEID))) {
            attributes.put(STATS_SERVER_SITEID, System.getProperty(STATS_SERVER_SITEID));
        }
        if (StringUtils.isNotBlank((String)System.getProperty(STATS_DIM_SPACEID))) {
            attributes.put(STATS_DIM_SPACEID, System.getProperty(STATS_DIM_SPACEID));
        }
        if (StringUtils.isNotBlank((String)System.getProperty(STATS_DIM_SPACETITLE))) {
            attributes.put(STATS_DIM_SPACETITLE, System.getProperty(STATS_DIM_SPACETITLE));
        }
    }

    public Set<String> getAttributeNames() {
        return this.names;
    }
}

