/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.customizer.plugin;

import fr.gouv.education.foad.customizer.plugin.fragment.DenyFromLocalAccountsFragment;
import fr.gouv.education.foad.customizer.plugin.fragment.TileFragmentModule;
import fr.gouv.education.foad.customizer.plugin.list.WorkspacesListTemplateModule;
import fr.gouv.education.foad.customizer.plugin.menubar.FoadMenubarModule;
import fr.toutatice.portail.cms.nuxeo.api.domain.AbstractPluginPortlet;
import fr.toutatice.portail.cms.nuxeo.api.domain.FragmentType;
import fr.toutatice.portail.cms.nuxeo.api.domain.ListTemplate;
import fr.toutatice.portail.cms.nuxeo.api.fragment.IFragmentModule;
import fr.toutatice.portail.cms.nuxeo.api.portlet.IPortletModule;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletContext;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.taskbar.TaskbarFactory;
import org.osivia.portal.api.taskbar.TaskbarItem;
import org.osivia.portal.api.taskbar.TaskbarItems;

public class FoadPlugin
extends AbstractPluginPortlet {
    private static final String PLUGIN_NAME = "foad.plugin";
    private final IBundleFactory bundleFactory;

    public FoadPlugin() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public int getOrder() {
        return 101;
    }

    protected String getPluginName() {
        return PLUGIN_NAME;
    }

    protected void customizeCMSProperties(String customizationID, CustomizationContext context) {
        this.customizeMenubarModules(context);
        this.customizeFragments(context);
        this.customizeListTemplates(context);
        this.customizeTaskbarItems(context);
    }

    private void customizeMenubarModules(CustomizationContext context) {
        List modules = this.getMenubarModules(context);
        FoadMenubarModule foadModule = new FoadMenubarModule();
        modules.add(foadModule);
    }

    private void customizeFragments(CustomizationContext context) {
        PortletContext portletContext = this.getPortletContext();
        Bundle bundle = this.bundleFactory.getBundle(context.getLocale());
        List fragmentTypes = this.getFragmentTypes(context);
        FragmentType denyFromLocalAccounts = new FragmentType("denyFromLocalAccounts", "Fragment interdit aux utilisateurs locaux", (IFragmentModule)new DenyFromLocalAccountsFragment(null, true));
        fragmentTypes.add(denyFromLocalAccounts);
        TileFragmentModule tileModule = new TileFragmentModule(portletContext);
        FragmentType tile = new FragmentType("tile", bundle.getString("FRAGMENT_TILE"), (IFragmentModule)tileModule);
        fragmentTypes.add(tile);
    }

    private void customizeListTemplates(CustomizationContext context) {
        PortletContext portletContext = this.getPortletContext();
        Bundle bundle = this.bundleFactory.getBundle(context.getLocale());
        Map templates = this.getListTemplates(context);
        ListTemplate events = new ListTemplate("events", bundle.getString("LIST_TEMPLATE_EVENTS"), "dublincore, toutatice, vevent");
        templates.put(events.getKey(), events);
        ListTemplate workspaces = new ListTemplate("workspaces", bundle.getString("LIST_TEMPLATE_WORKSPACES"), "dublincore, toutatice, toutatice_space");
        workspaces.setModule((IPortletModule)new WorkspacesListTemplateModule(portletContext));
        templates.put(workspaces.getKey(), workspaces);
    }

    private void customizeTaskbarItems(CustomizationContext context) {
        TaskbarItems items = this.getTaskbarItems(context);
        TaskbarFactory factory = this.getTaskbarService().getFactory();
        TaskbarItem search = factory.createStapledTaskbarItem("SEARCH", "SEARCH_TASK", null, "/default/templates/workspace/search");
        factory.hide(search, true);
        items.add(search);
        TaskbarItem lastModifications = factory.createCmsTaskbarItem("LAST_MODIFICATIONS", "WORKSPACE_LAST_MODIFICATIONS_TASK", null, null);
        lastModifications.setToDefault(1);
        factory.hide(lastModifications, true);
        items.add(lastModifications);
        for (String id : Arrays.asList("GALLERY")) {
            items.remove(id);
        }
    }
}

