/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.customizer.project;

import fr.gouv.education.foad.customizer.project.GetProfileCommand;
import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.Window;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.customization.CustomizationModuleMetadatas;
import org.osivia.portal.api.customization.ICustomizationModule;
import org.osivia.portal.api.customization.ICustomizationModulesRepository;
import org.osivia.portal.api.customization.IProjectCustomizationConfiguration;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.urls.IPortalUrlFactory;

public class ProjectCustomizer
extends CMSPortlet
implements ICustomizationModule {
    private static final String CUSTOMIZER_NAME = "foad.customizer.project";
    private static final String ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY = "CustomizationModulesRepository";
    private static final String FIRST_CONNECTION_INDICATOR_PROPERTY = "first-connection";
    private static final String CGU_LEVEL_SESSION_ATTRIBUTE = "osivia.services.cgu.level";
    private static final String COOKIE_NEW_VERSION = "version4416Accepted";
    private static final String COOKIE_ROUTE = "ROUTEID";
    private final IPortalUrlFactory portalUrlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
    private final PersonService personService = (PersonService)DirServiceFactory.getService(PersonService.class);
    private final IBundleFactory bundleFactory;
    private final CustomizationModuleMetadatas metadatas;
    private ICustomizationModulesRepository repository;
    private INotificationsService notificationService;

    public ProjectCustomizer() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
        this.notificationService = (INotificationsService)Locator.findMBean(INotificationsService.class, (String)"osivia:service=NotificationsService");
        this.metadatas = new CustomizationModuleMetadatas();
        this.metadatas.setName(CUSTOMIZER_NAME);
        this.metadatas.setModule((ICustomizationModule)this);
        this.metadatas.setCustomizationIDs(Arrays.asList("osivia.project.customizer.id"));
    }

    public void init() throws PortletException {
        this.repository = (ICustomizationModulesRepository)this.getPortletContext().getAttribute(ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY);
        this.repository.register(this.metadatas);
    }

    public void destroy() {
        this.repository.unregister(this.metadatas);
    }

    public void customize(String customizationId, CustomizationContext customizationContext) {
        PortalControllerContext portalControllerContext = customizationContext.getPortalControllerContext();
        Map attributes = customizationContext.getAttributes();
        IProjectCustomizationConfiguration configuration = (IProjectCustomizationConfiguration)attributes.get("osivia.project.customizer.configuration");
        HttpServletRequest servletRequest = configuration.getHttpServletRequest();
        Principal principal = servletRequest.getUserPrincipal();
        Bundle bundle = this.bundleFactory.getBundle(customizationContext.getLocale());
        if (configuration.isBeforeInvocation() && principal != null) {
            this.firstConnectionRedirection(portalControllerContext, configuration, principal, bundle);
            if (StringUtils.isNotEmpty((String)configuration.getCMSPath())) {
                this.cguRedirection(portalControllerContext, configuration, principal, bundle);
            }
        }
        if (configuration.isBeforeInvocation()) {
            this.oldVersionRedirection(customizationContext);
        }
    }

    private void firstConnectionRedirection(PortalControllerContext portalControllerContext, IProjectCustomizationConfiguration configuration, Principal principal, Bundle bundle) {
        Page page;
        Window window;
        Person person = this.personService.getPerson(principal.getName());
        if (!(person.getLastConnection() != null || (window = (page = configuration.getPage()) == null ? null : (Window)page.getChild("virtual", Window.class)) != null && BooleanUtils.toBoolean((String)window.getDeclaredProperty(FIRST_CONNECTION_INDICATOR_PROPERTY)))) {
            String redirectionUrl;
            String displayName = bundle.getString("FIRST_CONNECTION_TITLE");
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("osivia.title", displayName);
            properties.put("osivia.ajaxLink", "1");
            properties.put("theme.dyna.partial_refresh_enabled", String.valueOf(true));
            properties.put(FIRST_CONNECTION_INDICATOR_PROPERTY, String.valueOf(true));
            properties.put("osivia.services.firstConnection.redirectionUrl", StringEscapeUtils.escapeHtml((String)configuration.buildRestorableURL()));
            try {
                redirectionUrl = this.portalUrlFactory.getStartPortletInNewPage(portalControllerContext, FIRST_CONNECTION_INDICATOR_PROPERTY, displayName, "osivia-services-first-connection-instance", properties, null);
            }
            catch (PortalException e) {
                throw new RuntimeException(e);
            }
            configuration.setRedirectionURL(redirectionUrl);
        }
    }

    private void cguRedirection(PortalControllerContext portalControllerContext, IProjectCustomizationConfiguration configuration, Principal principal, Bundle bundle) {
        Page page = configuration.getPage();
        if (page != null) {
            Window window = (Window)page.getChild("virtual", Window.class);
            HttpServletRequest servletRequest = configuration.getHttpServletRequest();
            HttpSession session = servletRequest.getSession();
            NuxeoController nuxeoController = new NuxeoController(this.getPortletContext());
            nuxeoController.setServletRequest(servletRequest);
            String path = page.getProperty("osivia.services.cgu.path");
            String portalLevel = page.getProperty(CGU_LEVEL_SESSION_ATTRIBUTE);
            if (portalLevel == null || path == null) {
                return;
            }
            String checkedLevel = String.valueOf(session.getAttribute(CGU_LEVEL_SESSION_ATTRIBUTE));
            if (StringUtils.equals((String)portalLevel, (String)checkedLevel)) {
                return;
            }
            if (window != null && StringUtils.isNotEmpty((String)window.getDeclaredProperty("osivia.services.cgu.path"))) {
                return;
            }
            Document userProfile = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)new GetProfileCommand(principal.getName()));
            String userLevel = userProfile.getProperties().getString("ttc_userprofile:terms_of_use_agreement");
            session.setAttribute(CGU_LEVEL_SESSION_ATTRIBUTE, (Object)userLevel);
            if (!portalLevel.equals(userLevel)) {
                String redirectionUrl;
                session.setAttribute("osivia.services.cgu.pathToRedirect", (Object)configuration.buildRestorableURL());
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("osivia.services.cgu.path", path);
                properties.put(CGU_LEVEL_SESSION_ATTRIBUTE, portalLevel);
                properties.put("osivia.title", bundle.getString("CGU_TITLE"));
                properties.put("osivia.hideTitle", "1");
                try {
                    redirectionUrl = this.portalUrlFactory.getStartPortletInNewPage(portalControllerContext, "cgu", bundle.getString("CGU_TITLE_MINI"), "osivia-services-cgu-portailPortletInstance", properties, null);
                }
                catch (PortalException e) {
                    throw new RuntimeException(e);
                }
                configuration.setRedirectionURL(redirectionUrl);
            }
        }
    }

    private void oldVersionRedirection(CustomizationContext ctx) {
        Map attributes = ctx.getAttributes();
        IProjectCustomizationConfiguration configuration = (IProjectCustomizationConfiguration)attributes.get("osivia.project.customizer.configuration");
        HttpServletRequest request = configuration.getHttpServletRequest();
        if (request != null) {
            Cookie newVersionAccepted = null;
            Cookie route = null;
            if (request.getCookies() != null) {
                for (Cookie c : request.getCookies()) {
                    if (c.getName().equals(COOKIE_NEW_VERSION)) {
                        newVersionAccepted = c;
                    }
                    if (!c.getName().equals(COOKIE_ROUTE)) continue;
                    route = c;
                }
            }
            HttpServletResponse response = configuration.getHttpServletResponse();
            if (request.getParameter("oldVersion") != null) {
                String oldVersion = request.getParameter("oldVersion");
                Boolean booleanObject = BooleanUtils.toBooleanObject((String)oldVersion);
                newVersionAccepted = new Cookie(COOKIE_NEW_VERSION, booleanObject.toString());
                newVersionAccepted.setMaxAge(0);
                newVersionAccepted.setPath("/");
                response.addCookie(newVersionAccepted);
                this.changeRoute(ctx, configuration, route, response, booleanObject);
            }
        }
    }

    private void changeRoute(CustomizationContext ctx, IProjectCustomizationConfiguration configuration, Cookie route, HttpServletResponse response, Boolean booleanObject) {
        if (booleanObject.booleanValue()) {
            route = new Cookie(COOKIE_ROUTE, "");
            route.setPath("/");
            route.setMaxAge(0);
            response.addCookie(route);
            PortalControllerContext portalControllerContext = ctx.getPortalControllerContext();
            ControllerContext cc = (ControllerContext)portalControllerContext.getControllerCtx();
            String redirection = cc.getServerInvocation().getServerContext().getPortalContextPath();
            if (configuration.getCMSPath() != null) {
                redirection = redirection + "/cms/" + configuration.getCMSPath();
            }
            configuration.setRedirectionURL(redirection);
        }
    }
}

