/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.customizer.feeder;

import fr.gouv.education.foad.directory.model.TribuPerson;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Name;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.osivia.directory.v2.service.PersonUpdateService;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.customization.CustomizationModuleMetadatas;
import org.osivia.portal.api.customization.ICustomizationModule;
import org.osivia.portal.api.customization.ICustomizationModulesRepository;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Person;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class FeederCustomizer
extends GenericPortlet
implements ICustomizationModule {
    private final Logger fimlog = Logger.getLogger((String)"fim");
    private static final String CUSTOMIZER_NAME = "foad.customizer.feeder";
    private static final String ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY = "CustomizationModulesRepository";
    private static final String CAS_ATTRIBUTE_PREFIX = "cas:";
    private ICustomizationModulesRepository repository;
    private final CustomizationModuleMetadatas metadatas;
    private String employeeNumber = StringUtils.defaultIfBlank((String)System.getProperty("fim.headers.employeeNumber"), (String)"employeeNumber");
    private String title = StringUtils.defaultIfBlank((String)System.getProperty("fim.headers.title"), (String)"title");
    private String fonctAdm = StringUtils.defaultIfBlank((String)System.getProperty("fim.headers.fonctAdm"), (String)"FrEduFonctAdm");
    private String rne = StringUtils.defaultIfBlank((String)System.getProperty("fim.headers.rne"), (String)"rne");
    private String rneExerc = StringUtils.defaultIfBlank((String)System.getProperty("fim.headers.rneExerc"), (String)"FrEduRne");
    private String rneExerc_sep = StringUtils.defaultIfBlank((String)System.getProperty("fim.headers.rneExerc.sep"), (String)"\\$");
    private String rneResp = StringUtils.defaultIfBlank((String)System.getProperty("fim.headers.rneResp"), (String)"FrEduRneResp");
    private String rneResp_sep = StringUtils.defaultIfBlank((String)System.getProperty("fim.headers.rneExerc.sep"), (String)"\\$");
    private String aca = StringUtils.defaultIfBlank((String)System.getProperty("fim.headers.aca"), (String)"FrEduAca");
    private String codaca = StringUtils.defaultIfBlank((String)System.getProperty("fim.headers.codaca"), (String)"codaca");
    private String mailaca = StringUtils.defaultIfBlank((String)System.getProperty("fim.headers.mailaca"), (String)"ctemail");

    public FeederCustomizer() {
        this.metadatas = this.generateMetadatas();
    }

    private CustomizationModuleMetadatas generateMetadatas() {
        CustomizationModuleMetadatas metadatas = new CustomizationModuleMetadatas();
        metadatas.setName(CUSTOMIZER_NAME);
        metadatas.setModule((ICustomizationModule)this);
        metadatas.setCustomizationIDs(Arrays.asList("osivia.customizer.feeder.id"));
        return metadatas;
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        this.repository = (ICustomizationModulesRepository)this.getPortletContext().getAttribute(ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY);
        this.repository.register(this.metadatas);
    }

    public void destroy() {
        super.destroy();
        this.repository.unregister(this.metadatas);
    }

    public void customize(String customizationID, CustomizationContext context) {
        try {
            PersonUpdateService service;
            Node casAttributes;
            Map attributes = context.getAttributes();
            HttpServletRequest request = (HttpServletRequest)attributes.get("request");
            String response = (String)request.getAttribute("casresponse");
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(new InputSource(new StringReader(response)));
            Element authentication = (Element)doc.getElementsByTagName("cas:serviceResponse").item(0);
            HashMap<String, String> personAttributes = new HashMap<String, String>();
            String userId = authentication.getElementsByTagName("cas:user").item(0).getTextContent();
            NodeList casAttributesList = authentication.getElementsByTagName("cas:attributes");
            if (casAttributesList != null && (casAttributes = casAttributesList.item(0)) != null) {
                for (int i = 0; i < casAttributes.getChildNodes().getLength(); ++i) {
                    String attributeName;
                    Node casAttribute = casAttributes.getChildNodes().item(i);
                    if (casAttribute.getNodeType() != 1 || !(attributeName = casAttribute.getNodeName()).startsWith(CAS_ATTRIBUTE_PREFIX)) continue;
                    personAttributes.put(attributeName.substring(CAS_ATTRIBUTE_PREFIX.length()), casAttribute.getTextContent());
                }
            }
            if ((service = (PersonUpdateService)DirServiceFactory.getService(PersonUpdateService.class)) != null) {
                Name userDn = service.getEmptyPerson().buildDn(userId);
                Person person = service.getPersonNoCache(userDn);
                if (person == null) {
                    person = service.getEmptyPerson();
                    person.setUid(userId);
                    person.setSn((String)personAttributes.get("sn"));
                    person.setCn((String)personAttributes.get("cn"));
                    person.setDisplayName((String)personAttributes.get("displayName"));
                    person.setMail((String)personAttributes.get("mail"));
                    person.setGivenName((String)personAttributes.get("givenName"));
                    person.setExternal(Boolean.valueOf("fim".equals(personAttributes.get("source"))));
                    service.create(person);
                } else {
                    if (person.getExternal() == null) {
                        person.setExternal(Boolean.valueOf("fim".equals(personAttributes.get("source"))));
                    }
                    if (person.getLastConnection() != null) {
                        person.setLastConnection(new Date());
                        if (person.getCreationDate() == null) {
                            Calendar instance = Calendar.getInstance();
                            instance.set(2017, 8, 1, 0, 0);
                            person.setCreationDate(instance.getTime());
                        }
                    }
                    service.update(person);
                }
                if ("fim".equals(personAttributes.get("source"))) {
                    try {
                        this.computeFimHeaders(request, person);
                        service.update(person);
                    }
                    catch (Exception e) {
                        ArrayList<String> headerLogs = new ArrayList<String>();
                        Enumeration headerNames = request.getHeaderNames();
                        while (headerNames.hasMoreElements()) {
                            String nextElement = (String)headerNames.nextElement();
                            String header = request.getHeader(nextElement);
                            headerLogs.add(nextElement + " >> " + header);
                        }
                        this.fimlog.error((Object)("Erreur traitement des headers " + e.getMessage() + " " + headerLogs));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void computeFimHeaders(HttpServletRequest servletRequest, Person person) {
        if (person instanceof TribuPerson) {
            TribuPerson tribuPerson = (TribuPerson)person;
            this.fimlog.info((Object)"----------------");
            Enumeration headerNames = servletRequest.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                int i;
                String[] split;
                String nextElement = (String)headerNames.nextElement();
                this.fimlog.info((Object)("Traitement des headers " + nextElement + " " + servletRequest.getHeader(nextElement)));
                if (nextElement.equalsIgnoreCase(this.employeeNumber) && StringUtils.isNotBlank((String)servletRequest.getHeader(this.employeeNumber))) {
                    tribuPerson.setHashNumen(servletRequest.getHeader(this.employeeNumber));
                    continue;
                }
                if (nextElement.equalsIgnoreCase(this.title) && StringUtils.isNotBlank((String)servletRequest.getHeader(this.title))) {
                    tribuPerson.setFonction(servletRequest.getHeader(this.title));
                    continue;
                }
                if (nextElement.equalsIgnoreCase(this.fonctAdm) && StringUtils.isNotBlank((String)servletRequest.getHeader(this.fonctAdm))) {
                    tribuPerson.setFonctionAdm(servletRequest.getHeader(this.fonctAdm));
                    continue;
                }
                if (nextElement.equalsIgnoreCase(this.rne) && StringUtils.isNotBlank((String)servletRequest.getHeader(this.rne))) {
                    tribuPerson.setRne(servletRequest.getHeader(this.rne));
                    continue;
                }
                if (nextElement.equalsIgnoreCase(this.rneExerc) && StringUtils.isNotBlank((String)servletRequest.getHeader(this.rneExerc))) {
                    split = servletRequest.getHeader(this.rneExerc).split(this.rneExerc_sep);
                    tribuPerson.getRneExerc().clear();
                    for (i = 0; i < split.length; ++i) {
                        if (!StringUtils.isNotBlank((String)split[i])) continue;
                        tribuPerson.getRneExerc().add(split[i]);
                    }
                    continue;
                }
                if (nextElement.equalsIgnoreCase(this.rneResp) && StringUtils.isNotBlank((String)servletRequest.getHeader(this.rneResp))) {
                    split = servletRequest.getHeader(this.rneResp).split(this.rneResp_sep);
                    tribuPerson.getRneResp().clear();
                    for (i = 0; i < split.length; ++i) {
                        if (!StringUtils.isNotBlank((String)split[i])) continue;
                        tribuPerson.getRneResp().add(split[i]);
                    }
                    continue;
                }
                if (nextElement.equalsIgnoreCase(this.aca) && StringUtils.isNotBlank((String)servletRequest.getHeader(this.aca))) {
                    tribuPerson.setNomAcademie(servletRequest.getHeader(this.aca));
                    continue;
                }
                if (nextElement.equalsIgnoreCase(this.codaca) && StringUtils.isNotBlank((String)servletRequest.getHeader(this.codaca))) {
                    tribuPerson.setCodeAca(servletRequest.getHeader(this.codaca));
                    continue;
                }
                if (!nextElement.equalsIgnoreCase(this.mailaca) || !StringUtils.isNotBlank((String)servletRequest.getHeader(this.mailaca))) continue;
                tribuPerson.setMailAca(servletRequest.getHeader(this.mailaca));
            }
        }
    }
}

