/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.directory.v2;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import javax.portlet.PortletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.directory.v2.IDirDelegate;
import org.osivia.portal.api.directory.v2.IDirService;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.context.ApplicationContext;
import org.springframework.ldap.transaction.compensating.manager.ContextSourceTransactionManagerDelegate;
import org.springframework.stereotype.Service;
import org.springframework.web.portlet.context.PortletApplicationContextUtils;
import org.springframework.web.portlet.context.PortletContextAware;

@Service
public class DirDelegate
implements IDirDelegate,
PortletContextAware {
    protected static final Log LOGGER = LogFactory.getLog(DirDelegate.class);
    private PortletContext portletContext;
    private ApplicationContext appContext;
    private final ClassLoader serviceClassLoader = Thread.currentThread().getContextClassLoader();

    public <D extends IDirService> D getDirectoryService(Class<D> requiredType) throws InvocationTargetException {
        try {
            return (D)((IDirService)this.appContext.getBean(requiredType));
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new InvocationTargetException(ex, "No service registered with type " + requiredType);
        }
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public void setPortletContext(PortletContext ctx) {
        this.portletContext = ctx;
        this.appContext = PortletApplicationContextUtils.getWebApplicationContext((PortletContext)this.portletContext);
    }

    public void clearCaches() {
        EhCacheCacheManager cacheManager = (EhCacheCacheManager)this.appContext.getBean(EhCacheCacheManager.class);
        if (cacheManager != null) {
            Collection cacheNames = cacheManager.getCacheNames();
            for (String bean : cacheNames) {
                LOGGER.warn((Object)("clear cache : " + bean));
                cacheManager.getCache(bean).clear();
            }
        }
    }

    public ClassLoader getClassLoader() {
        return this.serviceClassLoader;
    }

    public ContextSourceTransactionManagerDelegate getDirectoryTxManagerDelegate() {
        return (ContextSourceTransactionManagerDelegate)this.appContext.getBean(ContextSourceTransactionManagerDelegate.class);
    }
}

