/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.directory.v2;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.cache.ehcache.EhCacheManagerFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@Configuration
@EnableCaching
@ComponentScan(basePackages={"org.osivia.directory.v2"})
public class DirAppContext {
    @Autowired
    private ApplicationContext context;

    @Bean(name={"ehcache"})
    public EhCacheManagerFactoryBean getCacheFactory() {
        EhCacheManagerFactoryBean factory = new EhCacheManagerFactoryBean();
        factory.setConfigLocation((Resource)new ClassPathResource("ehcache-ldap.xml"));
        return factory;
    }

    @Bean(name={"cacheManager"})
    public CacheManager getCacheManager() {
        EhCacheManagerFactoryBean bean = (EhCacheManagerFactoryBean)this.context.getBean(EhCacheManagerFactoryBean.class);
        EhCacheCacheManager ehCacheCacheManager = new EhCacheCacheManager(bean.getObject());
        return ehCacheCacheManager;
    }
}

