/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge;

import java.util.Map;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.portlet.faces.BridgeException;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portletbridge.ExceptionHandler;
import org.jboss.portletbridge.application.PortletWindowState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionHandlerImpl
implements ExceptionHandler {
    protected static final Log log = LogFactory.getLog(ExceptionHandlerImpl.class);

    @Override
    public void processActionException(FacesContext context, PortletWindowState windowState, Exception e) throws BridgeException {
        ErrorPage errorPage = this.getErrorViewId(windowState, e);
        if (null == errorPage) {
            throw new BridgeException("Error processing render lifecycle", (Throwable)e);
        }
        windowState.reset();
        this.setupErrorParameters(context, errorPage.getException());
        windowState.setViewId(errorPage.getLocation());
    }

    private void setupErrorParameters(FacesContext context, Throwable throwable) {
        Map requestMap = context.getExternalContext().getRequestMap();
        requestMap.put("javax.servlet.error.exception", throwable);
        requestMap.put("javax.servlet.error.status_code", 500);
        requestMap.put("javax.servlet.error.message", throwable.getLocalizedMessage());
        requestMap.put("javax.servlet.error.servlet_name", "Faces Servlet");
    }

    protected ErrorPage getErrorViewId(PortletWindowState windowState, Exception e) {
        Map<Class<? extends Throwable>, String> errorPages = windowState.getBridgeConfig().getErrorPages();
        return this.getErrorPage(e, errorPages);
    }

    protected ErrorPage getErrorPage(Throwable e, Map<Class<? extends Throwable>, String> errorPages) {
        Throwable cause = this.getCause(e);
        ErrorPage errorPage = null;
        if (null != cause && null != (errorPage = this.getErrorPage(cause, errorPages))) {
            return errorPage;
        }
        for (Class<? extends Throwable> errorClass : errorPages.keySet()) {
            if (!errorClass.isInstance(e) || !errorPages.containsKey(errorClass)) continue;
            errorPage = new ErrorPage(errorPages.get(errorClass), e);
        }
        return errorPage;
    }

    protected Throwable getCause(Throwable exception) {
        Throwable cause = null;
        cause = exception instanceof ServletException ? ((ServletException)exception).getRootCause() : exception.getCause();
        return cause;
    }

    @Override
    public void processRenderException(FacesContext context, PortletWindowState windowState, Exception e) throws BridgeException {
        ErrorPage errorPage = this.getErrorViewId(windowState, e);
        if (null == errorPage) {
            throw new BridgeException("Error processing render lifecycle", (Throwable)e);
        }
        UIViewRoot root = context.getApplication().getViewHandler().createView(context, errorPage.getLocation());
        this.setupErrorParameters(context, errorPage.getException());
        context.setViewRoot(root);
        windowState.getBridgeConfig().getFacesLifecycle().render(context);
    }

    private static class ErrorPage {
        private final String location;
        private final Throwable exception;

        public ErrorPage(String location, Throwable exception) {
            this.location = location;
            this.exception = exception;
        }

        public String getLocation() {
            return this.location;
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

