/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.api.event;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanProxyCreationException;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.portal.api.event.PortalEvent;
import org.jboss.portal.api.event.PortalEventContext;
import org.jboss.portal.api.event.PortalEventListener;
import org.jboss.portal.api.session.event.PortalSessionEvent;
import org.jboss.portal.api.user.event.UserAuthenticationEvent;
import org.jboss.portal.core.event.PortalEventListenerRegistry;
import org.jboss.portal.core.impl.api.PortalRuntimeContextImpl;
import org.jboss.portal.core.impl.api.event.PortalEventContextImpl;

public class ServletEventBridge
implements HttpSessionListener,
ServletContextListener,
HttpSessionAttributeListener {
    private PortalEventListenerRegistry listenerRegistry;

    public void contextInitialized(ServletContextEvent event) {
        try {
            this.listenerRegistry = (PortalEventListenerRegistry)MBeanProxy.get(PortalEventListenerRegistry.class, (ObjectName)ObjectNameFactory.create((String)"portal:service=ListenerRegistry"), (MBeanServer)MBeanServerLocator.locateJBoss());
        }
        catch (MBeanProxyCreationException e) {
            e.printStackTrace();
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.listenerRegistry = null;
    }

    public void sessionCreated(HttpSessionEvent event) {
        PortalRuntimeContextImpl rt = new PortalRuntimeContextImpl(event.getSession());
        PortalEventContextImpl uec = new PortalEventContextImpl(rt);
        PortalSessionEvent use = new PortalSessionEvent(0);
        this.fireEvent(uec, (PortalEvent)use);
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        PortalRuntimeContextImpl rt = new PortalRuntimeContextImpl(event.getSession());
        PortalEventContextImpl uec = new PortalEventContextImpl(rt);
        PortalSessionEvent use = new PortalSessionEvent(1);
        this.fireEvent(uec, (PortalEvent)use);
    }

    public void attributeAdded(HttpSessionBindingEvent event) {
        if ("PRINCIPAL_TOKEN".equals(event.getName())) {
            String userId = (String)event.getValue();
            PortalRuntimeContextImpl rt = new PortalRuntimeContextImpl(event.getSession(), userId);
            PortalEventContextImpl uec = new PortalEventContextImpl(rt);
            UserAuthenticationEvent uae = new UserAuthenticationEvent(userId, 0);
            this.fireEvent(uec, (PortalEvent)uae);
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        if ("PRINCIPAL_TOKEN".equals(event.getName())) {
            String userId = (String)event.getValue();
            PortalRuntimeContextImpl rt = new PortalRuntimeContextImpl(event.getSession(), userId);
            PortalEventContextImpl uec = new PortalEventContextImpl(rt);
            UserAuthenticationEvent uae = new UserAuthenticationEvent(userId, 1);
            this.fireEvent(uec, (PortalEvent)uae);
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
    }

    private void fireEvent(PortalEventContext eventContext, PortalEvent event) {
        for (Object o : this.listenerRegistry.getListeners()) {
            if (!(o instanceof PortalEventListener)) continue;
            PortalEventListener listener = (PortalEventListener)o;
            try {
                listener.onEvent(eventContext, event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

