/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.portlet.state;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jboss.portal.core.impl.portlet.state.PersistentConsumer;
import org.jboss.portal.core.impl.portlet.state.PersistentConsumerGroup;
import org.jboss.portal.core.impl.portlet.state.PersistentPortletState;
import org.jboss.portal.core.impl.portlet.state.PersistentPortletStateEntry;
import org.jboss.portal.core.impl.portlet.state.PersistentRegistration;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.portal.jems.hibernate.ObjectContextualizer;
import org.jboss.portal.portlet.state.InvalidStateIdException;
import org.jboss.portal.portlet.state.NoSuchStateException;
import org.jboss.portal.portlet.state.PropertyMap;
import org.jboss.portal.portlet.state.SimplePropertyMap;
import org.jboss.portal.portlet.state.producer.PortletStateContext;
import org.jboss.portal.portlet.state.producer.PortletStatePersistenceManager;
import org.jboss.portal.registration.Consumer;
import org.jboss.portal.registration.ConsumerGroup;
import org.jboss.portal.registration.DuplicateRegistrationException;
import org.jboss.portal.registration.NoSuchRegistrationException;
import org.jboss.portal.registration.Registration;
import org.jboss.portal.registration.RegistrationException;
import org.jboss.portal.registration.RegistrationLocal;
import org.jboss.portal.registration.RegistrationPersistenceManager;
import org.jboss.portal.registration.RegistrationStatus;

public class PersistentPortletStatePersistenceManager
extends AbstractJBossService
implements PortletStatePersistenceManager,
RegistrationPersistenceManager {
    protected SessionFactory sessionFactory;
    protected String sessionFactoryJNDIName;
    protected ObjectContextualizer contextualizer;

    public String getSessionFactoryJNDIName() {
        return this.sessionFactoryJNDIName;
    }

    public void setSessionFactoryJNDIName(String sessionFactoryJNDIName) {
        this.sessionFactoryJNDIName = sessionFactoryJNDIName;
    }

    public PortletStateContext loadState(String id) throws InvalidStateIdException, NoSuchStateException {
        Session session = this.getCurrentSession();
        return this.loadState(session, id);
    }

    public String createState(String portletId, PropertyMap propertyMap) {
        if (portletId == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        if (propertyMap == null) {
            throw new IllegalArgumentException("No null value map accepted");
        }
        Session session = this.getCurrentSession();
        PersistentPortletState context = new PersistentPortletState(portletId, propertyMap);
        session.persist((Object)context);
        PersistentRegistration registration = (PersistentRegistration)RegistrationLocal.getRegistration();
        if (registration != null) {
            registration.getRelatedPortletStates().add(context);
            context.setRelatedRegistration(registration);
        }
        session.flush();
        return context.getId();
    }

    public String cloneState(String stateId, PropertyMap propertyMap) throws InvalidStateIdException, NoSuchStateException {
        if (stateId == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        if (propertyMap == null) {
            throw new IllegalArgumentException("value map cannot be null");
        }
        Session session = this.getCurrentSession();
        PersistentPortletState parentContext = this.loadState(session, stateId);
        PersistentPortletState context = new PersistentPortletState(parentContext.getPortletId(), propertyMap);
        session.persist((Object)context);
        context.setParent(parentContext);
        parentContext.getChildren().add(context);
        session.update((Object)parentContext);
        PersistentRegistration registration = (PersistentRegistration)RegistrationLocal.getRegistration();
        if (registration != null) {
            registration.getRelatedPortletStates().add(context);
            context.setRelatedRegistration(registration);
        }
        session.flush();
        return context.getId();
    }

    public String cloneState(String stateId) throws IllegalArgumentException, NoSuchStateException, InvalidStateIdException {
        if (stateId == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        Session session = this.getCurrentSession();
        PersistentPortletState parentContext = this.loadState(session, stateId);
        PersistentPortletState context = new PersistentPortletState(parentContext.getPortletId(), (PropertyMap)new SimplePropertyMap(parentContext.getState().getProperties()));
        session.persist((Object)context);
        context.setParent(parentContext);
        parentContext.getChildren().add(context);
        session.update((Object)parentContext);
        PersistentRegistration registration = (PersistentRegistration)RegistrationLocal.getRegistration();
        if (registration != null) {
            registration.getRelatedPortletStates().add(context);
            context.setRelatedRegistration(registration);
        }
        session.flush();
        return context.getId();
    }

    public void updateState(String stateId, PropertyMap propertyMap) throws InvalidStateIdException, NoSuchStateException {
        Session session = this.getCurrentSession();
        PersistentPortletState context = this.loadState(session, stateId);
        context.entries.clear();
        for (String key : propertyMap.keySet()) {
            List value = propertyMap.getProperty(key);
            PersistentPortletStateEntry entry = new PersistentPortletStateEntry(key, value);
            context.entries.put(key, entry);
        }
        session.update((Object)context);
    }

    public void destroyState(String stateId) throws InvalidStateIdException, NoSuchStateException {
        if (stateId == null) {
            throw new IllegalArgumentException("No null state id accepted");
        }
        Session session = this.getCurrentSession();
        PersistentPortletState context = this.loadState(session, stateId);
        String update = "update PersistentPortletState p set p.parent=NULL where p.parent=:parent";
        Query query = session.createQuery(update).setLong("parent", context.getKey().longValue());
        query.executeUpdate();
        PersistentRegistration registration = context.getRelatedRegistration();
        if (registration != null) {
            registration.getRelatedPortletStates().remove(context);
            context.setRelatedRegistration(null);
        }
        session.delete((Object)context);
        session.flush();
    }

    protected void startService() throws Exception {
        this.sessionFactory = (SessionFactory)new InitialContext().lookup(this.sessionFactoryJNDIName);
        this.contextualizer = new ObjectContextualizer((Object)this);
        this.contextualizer.attach(this.sessionFactory);
    }

    protected void stopService() throws Exception {
        this.contextualizer = null;
        this.sessionFactory = null;
    }

    protected Session getCurrentSession() {
        return this.sessionFactory.getCurrentSession();
    }

    private PersistentPortletState loadState(Session session, String stateId) throws NoSuchStateException, InvalidStateIdException {
        if (stateId == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        try {
            Long key = new Long(stateId);
            PersistentPortletState context = (PersistentPortletState)session.get(PersistentPortletState.class, (Serializable)key);
            if (context == null) {
                throw new NoSuchStateException(stateId);
            }
            return context;
        }
        catch (NumberFormatException e) {
            throw new InvalidStateIdException((Throwable)e, stateId);
        }
    }

    public Consumer createConsumer(String consumerId, String consumerName) throws RegistrationException {
        if (consumerId == null) {
            throw new IllegalArgumentException("No null consumer id accepted");
        }
        if (consumerName == null) {
            throw new IllegalArgumentException("No null consumer name accepted");
        }
        Session session = this.getCurrentSession();
        PersistentConsumer consumer = new PersistentConsumer(consumerId, consumerName);
        session.persist((Object)consumer);
        return consumer;
    }

    public ConsumerGroup getConsumerGroup(String name) throws RegistrationException {
        Session session = this.getCurrentSession();
        return this.findGroupByName(session, name);
    }

    public ConsumerGroup createConsumerGroup(String name) throws RegistrationException {
        if (name == null) {
            throw new IllegalArgumentException("No null name accepted");
        }
        Session session = this.getCurrentSession();
        PersistentConsumerGroup group = null;
        if (this.findGroupByName(session, name) != null) {
            throw new DuplicateRegistrationException("Group " + name + " already exists");
        }
        group = new PersistentConsumerGroup(this, name);
        session.persist((Object)group);
        return group;
    }

    public void removeConsumerGroup(String name) throws RegistrationException {
        Session session = this.getCurrentSession();
        PersistentConsumerGroup group = this.getGroupByName(session, name);
        session.delete((Object)group);
    }

    public void removeConsumer(String consumerId) throws RegistrationException {
        Session session = this.getCurrentSession();
        PersistentConsumer consumer = this.getConsumerById(session, consumerId);
        session.delete((Object)consumer);
    }

    public void removeRegistration(String registrationId) throws RegistrationException {
        if (registrationId == null) {
            throw new IllegalArgumentException("No null registration id accepted");
        }
        Session session = this.getCurrentSession();
        PersistentRegistration registration = this.getRegistrationById(session, registrationId);
        PersistentConsumer consumer = registration.getRelatedConsumer();
        consumer.getRelatedRegistrations().remove(registration);
        registration.setRelatedConsumer(null);
        session.delete((Object)registration);
        session.flush();
    }

    public Consumer getConsumerById(String consumerId) throws RegistrationException {
        Session session = this.getCurrentSession();
        return this.findConsumerById(session, consumerId);
    }

    public Registration addRegistrationFor(String consumerId, Map registrationProperties) throws RegistrationException {
        if (registrationProperties == null) {
            throw new IllegalArgumentException("No null registration properties accepted");
        }
        Session session = this.getCurrentSession();
        PersistentConsumer consumer = this.getConsumerById(session, consumerId);
        PersistentRegistration registration = new PersistentRegistration(registrationProperties, RegistrationStatus.PENDING);
        registration.setRelatedConsumer(consumer);
        consumer.getRelatedRegistrations().add(registration);
        session.persist((Object)registration);
        session.saveOrUpdate((Object)consumer);
        return registration;
    }

    public Registration getRegistration(String registrationId) {
        Session session = this.getCurrentSession();
        return this.findRegistrationById(session, registrationId);
    }

    public Consumer addConsumerToGroupNamed(String consumerId, String groupName) throws RegistrationException {
        Consumer consumer = this.getConsumerById(consumerId);
        ConsumerGroup group = this.getConsumerGroup(groupName);
        consumer.setGroup(group);
        return consumer;
    }

    public Collection getConsumerGroups() {
        Session session = this.getCurrentSession();
        Query query = session.createQuery("from PersistentConsumerGroup");
        return query.list();
    }

    public Collection getConsumers() {
        Session session = this.getCurrentSession();
        Query query = session.createQuery("from PersistentConsumer");
        return query.list();
    }

    public Collection getRegistrations() {
        Session session = this.getCurrentSession();
        Query query = session.createQuery("from PersistentRegistration");
        return query.list();
    }

    private PersistentRegistration getRegistrationById(Session session, String registrationId) throws IllegalArgumentException, NoSuchRegistrationException {
        PersistentRegistration registration = this.findRegistrationById(session, registrationId);
        if (registration == null) {
            throw new NoSuchRegistrationException("Cant find a consumer with the id " + registrationId);
        }
        return registration;
    }

    private PersistentRegistration findRegistrationById(Session session, String registrationId) throws IllegalArgumentException {
        if (registrationId == null) {
            throw new IllegalArgumentException("No null consumer id accepted");
        }
        try {
            Long key = new Long(registrationId);
            return (PersistentRegistration)session.get(PersistentRegistration.class, (Serializable)key);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Bad registration id format " + registrationId);
        }
    }

    private PersistentConsumer getConsumerById(Session session, String consumerId) throws IllegalArgumentException, NoSuchRegistrationException {
        PersistentConsumer consumer = this.findConsumerById(session, consumerId);
        if (consumer == null) {
            throw new NoSuchRegistrationException("Cant find a consumer with the id " + consumerId);
        }
        return consumer;
    }

    private PersistentConsumer findConsumerById(Session session, String consumerId) throws IllegalArgumentException {
        if (consumerId == null) {
            throw new IllegalArgumentException("No null consumer id accepted");
        }
        Query query = session.createQuery("from PersistentConsumer where persistentId=:consumerId");
        query.setString("consumerId", consumerId);
        return (PersistentConsumer)query.uniqueResult();
    }

    private PersistentConsumerGroup getGroupByName(Session session, String groupName) throws IllegalArgumentException, NoSuchRegistrationException {
        PersistentConsumerGroup group = this.findGroupByName(session, groupName);
        if (group == null) {
            throw new NoSuchRegistrationException("Cant find a group with the name " + groupName);
        }
        return group;
    }

    private PersistentConsumerGroup findGroupByName(Session session, String groupName) throws IllegalArgumentException {
        if (groupName == null) {
            throw new IllegalArgumentException("No null group name accepted");
        }
        Query query = session.createQuery("from PersistentConsumerGroup where persistentName=:groupName");
        query.setString("groupName", groupName);
        return (PersistentConsumerGroup)query.uniqueResult();
    }
}

