/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.mx;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.management.Descriptor;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanModelMBeanBuilder {
    private static final String CURRENCY_TIME_LIMIT = "currencyTimeLimit";
    private static final String GET_METHOD = "getMethod";
    private static final String SET_METHOD = "setMethod";
    private static final String PERSIST_POLICY = "persistPolicy";
    private static final String ROLE = "role";
    private ArrayList mmais;
    private ArrayList mmois;
    private String className;
    private static final String GET = "get";
    private static final String IS = "is";
    private static final String SET = "set";

    public JavaBeanModelMBeanBuilder(Class from, Class to) throws Exception {
        if (from == null) {
            throw new IllegalArgumentException("The from class must not be null");
        }
        if (from.isInterface()) {
            throw new IllegalArgumentException("The from class " + from + " must not be an interface");
        }
        if (to != null) {
            if (to.isInterface()) {
                throw new IllegalArgumentException("The to class " + to + " must not be an interface");
            }
            if (!to.isAssignableFrom(from)) {
                throw new IllegalArgumentException("The from class " + from + " is not a subclass of " + to);
            }
        }
        HashMap<String, Method> beanGetters = new HashMap<String, Method>();
        HashMap<String, Method> beanSetters = new HashMap<String, Method>();
        HashMap<MethodKey, Method> beanMethods = new HashMap<MethodKey, Method>();
        for (Class c = from; c != null && !c.equals(to); c = c.getSuperclass()) {
            Method[] methods;
            HashMap<String, Method> currentClassGetters = new HashMap<String, Method>();
            HashMap<String, Method> currentClassSetters = new HashMap<String, Method>();
            for (Method method : methods = c.getDeclaredMethods()) {
                int modifiers = method.getModifiers();
                if (!Modifier.isPublic(modifiers) || Modifier.isAbstract(modifiers) || Modifier.isStatic(modifiers)) continue;
                String methodName = method.getName();
                Class<?> returnType = method.getReturnType();
                Class<?>[] parameterTypes = method.getParameterTypes();
                int prefixLength = 0;
                boolean isPotentialGetter = false;
                if (methodName.startsWith(GET)) {
                    prefixLength = 3;
                    isPotentialGetter = true;
                } else if (methodName.startsWith(IS)) {
                    prefixLength = 2;
                    isPotentialGetter = true;
                } else if (methodName.startsWith(SET)) {
                    prefixLength = 3;
                }
                if (methodName.length() > prefixLength) {
                    if (isPotentialGetter && !Void.TYPE.equals(returnType) && parameterTypes.length == 0) {
                        this.processPropertyOperation(method, currentClassGetters, currentClassSetters, beanSetters, prefixLength, false);
                    } else if (methodName.startsWith(SET) && Void.TYPE.equals(returnType) && parameterTypes.length == 1) {
                        this.processPropertyOperation(method, currentClassSetters, currentClassGetters, beanGetters, prefixLength, true);
                    }
                }
                beanMethods.put(new MethodKey(method), method);
            }
            beanGetters.putAll(currentClassGetters);
            beanSetters.putAll(currentClassSetters);
        }
        HashMap<Method, String> roles = new HashMap<Method, String>();
        this.mmais = new ArrayList();
        HashSet allPropertyNames = new HashSet();
        allPropertyNames.addAll(beanGetters.keySet());
        allPropertyNames.addAll(beanSetters.keySet());
        for (String propertyName : allPropertyNames) {
            Method getter = (Method)beanGetters.get(propertyName);
            Method setter = (Method)beanSetters.get(propertyName);
            ModelMBeanAttributeInfo mmai = new ModelMBeanAttributeInfo(propertyName, "Javabean introspected attribute", getter, setter);
            Descriptor desc = mmai.getDescriptor();
            desc.setField(CURRENCY_TIME_LIMIT, "-1");
            desc.setField(PERSIST_POLICY, "Never");
            if (getter != null) {
                roles.put(getter, "getter");
                desc.setField(GET_METHOD, getter.getName());
            }
            if (setter != null) {
                roles.put(setter, "setter");
                desc.setField(SET_METHOD, setter.getName());
            }
            mmai.setDescriptor(desc);
            this.mmais.add(mmai);
        }
        this.className = from.getName();
        this.mmois = new ArrayList();
        for (Method method : beanMethods.values()) {
            ModelMBeanOperationInfo mmoi = new ModelMBeanOperationInfo("Javabean introspected method", method);
            Descriptor desc = mmoi.getDescriptor();
            String role = (String)roles.get(method);
            desc.setField(ROLE, role != null ? role : "operation");
            mmoi.setDescriptor(desc);
            this.mmois.add(mmoi);
        }
    }

    private void processPropertyOperation(Method operation, Map<String, Method> currentClassOperations, Map<String, Method> currentClassReverseOperations, Map beanReverseOperations, int prefixLength, boolean isSetter) {
        Method op;
        String propertyName = operation.getName().substring(prefixLength);
        Method reverseOp = currentClassReverseOperations.get(propertyName);
        if (reverseOp == null) {
            reverseOp = (Method)beanReverseOperations.get(propertyName);
        }
        if (reverseOp != null) {
            Class<?> reverseOpType;
            Class<?> opType = isSetter ? operation.getParameterTypes()[0] : operation.getReturnType();
            Class<?> clazz = reverseOpType = isSetter ? reverseOp.getReturnType() : reverseOp.getParameterTypes()[0];
            if (!reverseOpType.equals(opType)) {
                throw new IllegalArgumentException("Property " + propertyName + " has a " + this.getterOrSetter(isSetter) + " type " + reverseOpType + " different from the corresponding " + this.getterOrSetter(!isSetter) + " type " + opType);
            }
        }
        if ((op = currentClassOperations.get(propertyName)) != null) {
            throw new IllegalArgumentException("Property " + propertyName + " has two " + this.getterOrSetter(isSetter) + "s " + op + " and " + operation);
        }
        currentClassOperations.put(propertyName, operation);
    }

    private String getterOrSetter(boolean isSetter) {
        return isSetter ? "setter" : "getter";
    }

    public void remove(Class itf) {
        throw new UnsupportedOperationException("To be implemented if useful, just a placeholder now");
    }

    public ModelMBeanInfo getInfo() {
        ModelMBeanInfoSupport info = new ModelMBeanInfoSupport(this.className, "Javabean model mbean", this.mmais.toArray(new ModelMBeanAttributeInfo[this.mmais.size()]), new ModelMBeanConstructorInfo[0], this.mmois.toArray(new ModelMBeanOperationInfo[this.mmois.size()]), new ModelMBeanNotificationInfo[0]);
        return info;
    }

    public static ModelMBeanInfo build(Class from, Class to) throws Exception {
        return new JavaBeanModelMBeanBuilder(from, to).getInfo();
    }

    public static ModelMBeanInfo build(Object o) throws Exception {
        return new JavaBeanModelMBeanBuilder(o.getClass(), null).getInfo();
    }

    private static class MethodKey {
        private final String name;
        private final Class[] parameterTypes;
        private final int hashCode;

        public MethodKey(Method method) {
            this.name = method.getName();
            this.parameterTypes = method.getParameterTypes();
            int hashCode = method.getName().hashCode();
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                Class parameterType = this.parameterTypes[i];
                hashCode = hashCode * 43 + parameterType.hashCode();
            }
            this.hashCode = hashCode;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof MethodKey) {
                MethodKey that = (MethodKey)obj;
                if (that.name.equals(this.name) && that.parameterTypes.length == this.parameterTypes.length) {
                    for (int i = 0; i < that.parameterTypes.length; ++i) {
                        if (that.parameterTypes[i].equals(this.parameterTypes[i])) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
    }
}

