/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.protocol.spec200702;

import javax.xml.datatype.Duration;
import org.jboss.ws.extensions.wsrm.api.RMException;
import org.jboss.ws.extensions.wsrm.common.serialization.RMAbstractSerializable;
import org.jboss.ws.extensions.wsrm.protocol.RMProvider;
import org.jboss.ws.extensions.wsrm.protocol.spec200702.RMProviderImpl;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMCreateSequenceResponse;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMIncompleteSequenceBehavior;

final class RMCreateSequenceResponseImpl
extends RMAbstractSerializable
implements RMCreateSequenceResponse {
    private static final RMProvider PROVIDER = RMProviderImpl.getInstance();
    private String identifier;
    private Duration expires;
    private RMCreateSequenceResponse.RMAccept accept;
    private RMIncompleteSequenceBehavior incompleteSequenceBehavior;

    RMCreateSequenceResponseImpl() {
    }

    public RMCreateSequenceResponse.RMAccept getAccept() {
        return this.accept;
    }

    public Duration getExpires() {
        return this.expires;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public RMIncompleteSequenceBehavior getIncompleteSequenceBehavior() {
        return this.incompleteSequenceBehavior;
    }

    public RMCreateSequenceResponse.RMAccept newAccept() {
        return new AcceptImpl();
    }

    public void setAccept(RMCreateSequenceResponse.RMAccept accept) {
        if (accept == null) {
            throw new IllegalArgumentException("Accept cannot be null");
        }
        if (!(accept instanceof AcceptImpl)) {
            throw new IllegalArgumentException();
        }
        if (accept.getAcksTo() == null) {
            throw new IllegalArgumentException("Accept acksTo must be specified");
        }
        if (this.accept != null) {
            throw new UnsupportedOperationException("Value already set, cannot be overriden");
        }
        this.accept = accept;
    }

    public void setExpires(Duration duration) {
        if (duration == null || duration.toString().equals("")) {
            throw new IllegalArgumentException("Duration cannot be null nor empty string");
        }
        if (this.expires != null) {
            throw new UnsupportedOperationException("Value already set, cannot be overriden");
        }
        this.expires = duration;
    }

    public void setIdentifier(String identifier) {
        if (identifier == null || identifier.trim().equals("")) {
            throw new IllegalArgumentException("Identifier cannot be null nor empty string");
        }
        if (this.identifier != null) {
            throw new UnsupportedOperationException("Value already set, cannot be overriden");
        }
        this.identifier = identifier;
    }

    public void setIncompleteSequenceBehavior(RMIncompleteSequenceBehavior incompleteSequenceBehavior) {
        if (incompleteSequenceBehavior == null) {
            throw new IllegalArgumentException("Sequence behavior type cannot be null");
        }
        if (this.incompleteSequenceBehavior != null) {
            throw new UnsupportedOperationException("Value already set, cannot be overriden");
        }
        this.incompleteSequenceBehavior = incompleteSequenceBehavior;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accept == null ? 0 : this.accept.hashCode());
        result = 31 * result + (this.expires == null ? 0 : this.expires.hashCode());
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = 31 * result + (this.incompleteSequenceBehavior == null ? 0 : this.incompleteSequenceBehavior.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RMCreateSequenceResponseImpl)) {
            return false;
        }
        RMCreateSequenceResponseImpl other = (RMCreateSequenceResponseImpl)obj;
        if (this.accept == null ? other.accept != null : !this.accept.equals(other.accept)) {
            return false;
        }
        if (this.expires == null ? other.expires != null : !this.expires.equals(other.expires)) {
            return false;
        }
        if (this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier)) {
            return false;
        }
        return !(this.incompleteSequenceBehavior == null ? other.incompleteSequenceBehavior != null : !this.incompleteSequenceBehavior.equals((Object)other.incompleteSequenceBehavior));
    }

    public RMProvider getProvider() {
        return PROVIDER;
    }

    public void validate() {
        if (this.identifier == null) {
            throw new RMException("Identifier must be set");
        }
    }

    private static class AcceptImpl
    implements RMCreateSequenceResponse.RMAccept {
        private String acksTo;

        private AcceptImpl() {
        }

        public String getAcksTo() {
            return this.acksTo;
        }

        public void setAcksTo(String address) {
            if (address == null || address.trim().equals("")) {
                throw new IllegalArgumentException("Address cannot be null nor empty string");
            }
            if (this.acksTo != null) {
                throw new UnsupportedOperationException("Value already set, cannot be overriden");
            }
            this.acksTo = address;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.acksTo == null ? 0 : this.acksTo.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AcceptImpl)) {
                return false;
            }
            AcceptImpl other = (AcceptImpl)obj;
            return !(this.acksTo == null ? other.acksTo != null : !this.acksTo.equals(other.acksTo));
        }
    }
}

