/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterResponseStream;
import net.bull.javamelody.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CounterStorage {
    private static boolean storageDisabled;
    private final Counter counter;

    CounterStorage(Counter counter) {
        assert (counter != null);
        this.counter = counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int writeToFile() throws IOException {
        if (storageDisabled) {
            return -1;
        }
        File file = this.getFile();
        if (this.counter.getRequestsCount() == 0 && this.counter.getErrorsCount() == 0 && !file.exists()) {
            return -1;
        }
        File directory = file.getParentFile();
        if (!directory.mkdirs() && !directory.exists()) {
            throw new IOException("JavaMelody directory can't be created: " + directory.getPath());
        }
        FileOutputStream out = new FileOutputStream(file);
        try {
            CounterResponseStream counterOutput = new CounterResponseStream(new GZIPOutputStream(new BufferedOutputStream(out)));
            ObjectOutputStream output = new ObjectOutputStream((OutputStream)((Object)counterOutput));
            try {
                output.writeObject(this.counter);
            }
            finally {
                output.close();
            }
            int n = counterOutput.getDataLength();
            return n;
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Counter readFromFile() throws IOException {
        if (storageDisabled) {
            return null;
        }
        File file = this.getFile();
        if (file.exists()) {
            FileInputStream in = new FileInputStream(file);
            try {
                Counter counter;
                ObjectInputStream input = new ObjectInputStream(new GZIPInputStream(new BufferedInputStream(in)));
                try {
                    counter = (Counter)input.readObject();
                }
                catch (Throwable throwable) {
                    try {
                        input.close();
                        throw throwable;
                    }
                    catch (ClassNotFoundException e) {
                        throw CounterStorage.createIOException(e);
                    }
                }
                input.close();
                return counter;
            }
            finally {
                in.close();
            }
        }
        return null;
    }

    private File getFile() {
        File storageDirectory = Parameters.getStorageDirectory(this.counter.getApplication());
        return new File(storageDirectory, this.counter.getStorageName() + ".ser.gz");
    }

    private static IOException createIOException(Exception e) {
        IOException ex = new IOException(e.getMessage());
        ex.initCause(e);
        return ex;
    }

    static long deleteObsoleteCounterFiles(String application) {
        Calendar nowMinusOneYearAndADay = Calendar.getInstance();
        nowMinusOneYearAndADay.add(1, -1);
        nowMinusOneYearAndADay.add(6, -1);
        long diskUsage = 0L;
        for (File file : CounterStorage.listSerGzFiles(application)) {
            boolean deleted = false;
            if (file.lastModified() < nowMinusOneYearAndADay.getTimeInMillis()) {
                deleted = file.delete();
            }
            if (deleted) continue;
            diskUsage += file.length();
        }
        return diskUsage;
    }

    private static List<File> listSerGzFiles(String application) {
        FilenameFilter filenameFilter;
        File storageDir = Parameters.getStorageDirectory(application);
        File[] files = storageDir.listFiles(filenameFilter = new FilenameFilter(){

            public boolean accept(File dir, String fileName) {
                return fileName.endsWith(".ser.gz");
            }
        });
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(files);
    }

    static void disableStorage() {
        storageDisabled = true;
    }
}

