/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.taglib.toutatice;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.taglib.common.ToutaticeSimpleTag;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.osivia.portal.api.html.HtmlFormatter;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;

public class FileSizeTag
extends ToutaticeSimpleTag {
    private static final String[] UNITS = new String[]{"BYTE", "KILOBYTE", "MEGABYTE", "GIGABYTE", "TERABYTE"};
    private static final double UNIT_FACTOR = 1024.0;
    private Long size;
    private final IBundleFactory bundleFactory;

    public FileSizeTag() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(((Object)((Object)this)).getClass().getClassLoader());
    }

    @Override
    protected void doTag(NuxeoController nuxeoController, DocumentDTO document) throws JspException, IOException {
        PageContext pageContext = (PageContext)this.getJspContext();
        ServletRequest request = pageContext.getRequest();
        Locale locale = request.getLocale();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        JspWriter out = pageContext.getOut();
        out.write(HtmlFormatter.formatSize((Locale)locale, (Bundle)bundle, (long)this.size));
    }

    public void setSize(Long size) {
        this.size = size;
    }
}

