/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.metadata.portlet;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import org.jboss.portal.common.io.UndeclaredIOException;
import org.jboss.portal.core.metadata.portlet.MarkupAttribute;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class MarkupElement {
    final String name;
    final String bodyContent;
    final boolean neverEmpty;
    final MarkupAttribute[] attributes;

    public MarkupElement(String name, String bodyContent, boolean neverEmpty, MarkupAttribute[] attributes) {
        if (name == null) {
            throw new IllegalArgumentException("No null name accepted");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("No null attributes accepted");
        }
        HashSet<String> tmp = new HashSet<String>(attributes.length);
        for (MarkupAttribute attribute : attributes) {
            if (attribute == null) {
                throw new IllegalArgumentException("Cannot have a null attribute");
            }
            if (tmp.add(attribute.getName())) continue;
            throw new IllegalArgumentException("Cannot have two identical attributes " + attribute.getName());
        }
        this.name = name;
        this.bodyContent = bodyContent;
        this.neverEmpty = neverEmpty;
        this.attributes = (MarkupAttribute[])attributes.clone();
    }

    public String getName() {
        return this.name;
    }

    public String getBodyContent() {
        return this.bodyContent;
    }

    public boolean isNeverEmpty() {
        return this.neverEmpty;
    }

    public int getAttributeSize() {
        return this.attributes.length;
    }

    public MarkupAttribute getAttribute(int index) {
        return this.attributes[index];
    }

    public MarkupAttribute getAttribute(String name) {
        for (MarkupAttribute attribute : this.attributes) {
            if (!attribute.getName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    public void write(String urlPrefix, Writer writer) throws UndeclaredIOException {
        if (urlPrefix == null) {
            throw new IllegalArgumentException("No context path provided");
        }
        if (writer == null) {
            throw new IllegalArgumentException("No writer provided");
        }
        try {
            writer.write("<");
            writer.write(this.name);
            for (MarkupAttribute attribute : this.attributes) {
                writer.write(" ");
                attribute.write(urlPrefix, writer);
            }
            if (this.bodyContent != null && this.bodyContent.length() > 0) {
                writer.write(">");
                writer.write(this.bodyContent);
                writer.write("</");
                writer.write(this.name);
                writer.write(">\n");
            } else if (this.neverEmpty) {
                writer.write(">");
                writer.write("</");
                writer.write(this.name);
                writer.write(">\n");
            } else {
                writer.write("/>\n");
            }
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    public String toString(String contextPath) {
        StringWriter buffer = new StringWriter(128);
        this.write(contextPath, buffer);
        return buffer.toString();
    }

    public String toString() {
        return this.toString("");
    }

    public Element toElement(String contextPath) {
        return new SimpleElement(contextPath);
    }

    private class SimpleElement
    implements Element {
        private String contextPath;

        private SimpleElement(String contextPath) {
            this.contextPath = contextPath;
        }

        public String toString() {
            return MarkupElement.this.toString(this.contextPath);
        }

        public String getTagName() {
            return MarkupElement.this.name;
        }

        public String getAttribute(String name) {
            return MarkupElement.this.getAttribute(name).getEncodedValue(this.contextPath);
        }

        public void setAttribute(String name, String value) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public void removeAttribute(String name) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public Attr getAttributeNode(String name) {
            throw new UnsupportedOperationException();
        }

        public Attr setAttributeNode(Attr newAttr) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public NodeList getElementsByTagName(String name) {
            throw new UnsupportedOperationException();
        }

        public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public boolean hasAttribute(String name) {
            throw new UnsupportedOperationException();
        }

        public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public TypeInfo getSchemaTypeInfo() {
            throw new UnsupportedOperationException();
        }

        public void setIdAttribute(String name, boolean isId) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public String getNodeName() {
            return this.getTagName();
        }

        public String getNodeValue() throws DOMException {
            return null;
        }

        public void setNodeValue(String nodeValue) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public short getNodeType() {
            return 1;
        }

        public Node getParentNode() {
            throw new UnsupportedOperationException();
        }

        public NodeList getChildNodes() {
            throw new UnsupportedOperationException();
        }

        public Node getFirstChild() {
            throw new UnsupportedOperationException();
        }

        public Node getLastChild() {
            throw new UnsupportedOperationException();
        }

        public Node getPreviousSibling() {
            throw new UnsupportedOperationException();
        }

        public Node getNextSibling() {
            throw new UnsupportedOperationException();
        }

        public NamedNodeMap getAttributes() {
            throw new UnsupportedOperationException();
        }

        public Document getOwnerDocument() {
            throw new UnsupportedOperationException();
        }

        public Node insertBefore(Node newChild, Node refChild) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public Node removeChild(Node oldChild) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public Node appendChild(Node newChild) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public boolean hasChildNodes() {
            throw new UnsupportedOperationException();
        }

        public Node cloneNode(boolean deep) {
            throw new UnsupportedOperationException();
        }

        public void normalize() {
            throw new UnsupportedOperationException();
        }

        public boolean isSupported(String feature, String version) {
            throw new UnsupportedOperationException();
        }

        public String getNamespaceURI() {
            throw new UnsupportedOperationException();
        }

        public String getPrefix() {
            throw new UnsupportedOperationException();
        }

        public void setPrefix(String prefix) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public String getLocalName() {
            return this.getTagName();
        }

        public boolean hasAttributes() {
            return MarkupElement.this.getAttributeSize() != 0;
        }

        public String getBaseURI() {
            throw new UnsupportedOperationException();
        }

        public short compareDocumentPosition(Node other) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public String getTextContent() throws DOMException {
            return MarkupElement.this.getBodyContent();
        }

        public void setTextContent(String textContent) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public boolean isSameNode(Node other) {
            throw new UnsupportedOperationException();
        }

        public String lookupPrefix(String namespaceURI) {
            throw new UnsupportedOperationException();
        }

        public boolean isDefaultNamespace(String namespaceURI) {
            throw new UnsupportedOperationException();
        }

        public String lookupNamespaceURI(String prefix) {
            throw new UnsupportedOperationException();
        }

        public boolean isEqualNode(Node arg) {
            throw new UnsupportedOperationException();
        }

        public Object getFeature(String feature, String version) {
            throw new UnsupportedOperationException();
        }

        public Object setUserData(String key, Object data, UserDataHandler handler) {
            throw new UnsupportedOperationException();
        }

        public Object getUserData(String key) {
            throw new UnsupportedOperationException();
        }
    }
}

