/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.property;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.varia.property.PropertyEditorManagerServiceMBean;

public class PropertyEditorManagerService
extends ServiceMBeanSupport
implements PropertyEditorManagerServiceMBean {
    private List registeredEditors = Collections.synchronizedList(new ArrayList());

    public PropertyEditor findEditor(Class type) {
        return PropertyEditorManager.findEditor(type);
    }

    public PropertyEditor findEditor(String typeName) throws ClassNotFoundException {
        Class<?> type = Class.forName(typeName);
        return PropertyEditorManager.findEditor(type);
    }

    public void registerEditor(Class type, Class editorType) {
        this.registeredEditors.add(type);
        PropertyEditorManager.registerEditor(type, editorType);
    }

    public void registerEditor(String typeName, String editorTypeName) throws ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> type = cl.loadClass(typeName);
        Class<?> editorType = cl.loadClass(editorTypeName);
        this.registerEditor(type, editorType);
    }

    private String makeString(String[] array) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            buff.append(array[i]);
            if (i + 1 >= array.length) continue;
            buff.append(",");
        }
        return buff.toString();
    }

    private String[] makeArray(String listspec) {
        StringTokenizer stok = new StringTokenizer(listspec, ",");
        ArrayList<String> list = new ArrayList<String>();
        while (stok.hasMoreTokens()) {
            String url = stok.nextToken();
            list.add(url);
        }
        return list.toArray(new String[list.size()]);
    }

    public String getEditorSearchPath() {
        return this.makeString(PropertyEditorManager.getEditorSearchPath());
    }

    public void setEditorSearchPath(String path) {
        PropertyEditorManager.setEditorSearchPath(this.makeArray(path));
    }

    public void setBootstrapEditors(String propsString) throws ClassNotFoundException, IOException {
        Properties props = new Properties();
        ByteArrayInputStream stream = new ByteArrayInputStream(propsString.getBytes());
        props.load(stream);
        this.setEditors(props);
    }

    public void setEditors(Properties props) throws ClassNotFoundException {
        for (String string : props.keySet()) {
            String editorTypeName = props.getProperty(string);
            this.registerEditor(string, editorTypeName);
        }
    }

    public Class[] getRegisteredEditors() {
        return this.registeredEditors.toArray(new Class[this.registeredEditors.size()]);
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? OBJECT_NAME : name;
    }

    protected void destroyService() throws Exception {
        Iterator iter = this.registeredEditors.iterator();
        while (iter.hasNext()) {
            Class type = (Class)iter.next();
            PropertyEditorManager.registerEditor(type, null);
            iter.remove();
        }
    }
}

