/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.identity.security;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jbpm.identity.User;
import org.jbpm.identity.security.AuthenticatedUser;
import org.jbpm.identity.security.IdentityService;
import org.jbpm.identity.security.Password;
import org.jbpm.identity.security.Username;

public class IdentityLoginModule
implements LoginModule {
    Subject subject = null;
    CallbackHandler callbackHandler = null;
    Map sharedState = null;
    Map options = null;
    IdentityService identityService = null;
    Object validatedUserId = null;
    String validatedPwd = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
    }

    @Override
    public boolean login() throws LoginException {
        boolean success;
        NameCallback nameCallback = new NameCallback(null);
        PasswordCallback passwordCallback = new PasswordCallback(null, false);
        try {
            this.callbackHandler.handle(new Callback[]{nameCallback, passwordCallback});
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LoginException("callback failed");
        }
        String userName = nameCallback.getName();
        String pwd = new String(passwordCallback.getPassword());
        Object userId = this.identityService.verify(userName, pwd);
        boolean bl = success = userId != null;
        if (success) {
            this.validatedUserId = userId;
            this.validatedPwd = pwd;
        } else {
            this.validatedUserId = null;
            this.validatedPwd = null;
        }
        return success;
    }

    @Override
    public boolean commit() throws LoginException {
        User user = this.identityService.getUserById(this.validatedUserId);
        if (user == null) {
            throw new LoginException("no user for validated user id '" + this.validatedUserId);
        }
        this.subject.getPrincipals().add(user);
        this.subject.getPrivateCredentials().add(new Username(user.getName()));
        this.subject.getPrivateCredentials().add(new Password(this.validatedPwd));
        AuthenticatedUser.setAuthenticatedUser(user);
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return this.logout();
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.subject != null) {
            this.subject.getPrincipals().clear();
            this.subject.getPublicCredentials().clear();
            this.subject.getPrivateCredentials().clear();
        }
        AuthenticatedUser.setAuthenticatedUser(null);
        this.callbackHandler = null;
        this.sharedState = null;
        this.options = null;
        this.validatedUserId = null;
        this.validatedPwd = null;
        return true;
    }
}

