/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.aspects.portlet;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.PortletInvokerInterceptor;
import org.jboss.portal.portlet.container.PortletApplication;
import org.jboss.portal.portlet.container.PortletApplicationContext;
import org.jboss.portal.portlet.container.PortletContainer;
import org.jboss.portal.portlet.impl.info.ContainerTypeInfo;
import org.jboss.portal.portlet.info.EventInfo;
import org.jboss.portal.portlet.info.EventingInfo;
import org.jboss.portal.portlet.info.PortletInfo;
import org.jboss.portal.portlet.invocation.EventInvocation;
import org.jboss.portal.portlet.invocation.PortletInvocation;
import org.jboss.portal.portlet.invocation.response.ErrorResponse;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;

public class EventPayloadInterceptor
extends PortletInvokerInterceptor {
    private static final Logger log = Logger.getLogger(EventPayloadInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortletInvocationResponse invoke(PortletInvocation invocation) throws IllegalArgumentException, PortletInvokerException {
        if (invocation instanceof EventInvocation) {
            EventInvocation eventInvocation = (EventInvocation)invocation;
            Serializable srcPayload = eventInvocation.getPayload();
            Serializable dstPayload = null;
            if (srcPayload != null) {
                PortletContainer container = (PortletContainer)invocation.getAttribute("PORTLET_CONTAINER");
                PortletApplication application = container.getPortletApplication();
                PortletApplicationContext applicationContext = application.getContext();
                ClassLoader applicationClassLoader = applicationContext.getClassLoader();
                String srcPayloadClassName = srcPayload.getClass().getName();
                boolean trace = log.isTraceEnabled();
                QName eventName = eventInvocation.getName();
                String containerId = container.getId();
                String applicationId = application.getId();
                PortletInfo info = container.getInfo();
                EventingInfo eventingInfo = info.getEventing();
                Map<QName, ? extends EventInfo> consumedEventInfos = eventingInfo.getConsumedEvents();
                EventInfo eventInfo = consumedEventInfos.get(eventName);
                if (trace) {
                    log.trace((Object)("Attempt to obtain for event " + eventName + " its payload class " + srcPayloadClassName + " in the application " + applicationId + " for portlet " + container.getInfo()));
                }
                Class<?> dstPayloadClass = null;
                if (eventInfo != null) {
                    ContainerTypeInfo typeInfo = (ContainerTypeInfo)eventInfo.getType();
                    if (typeInfo != null) {
                        dstPayloadClass = typeInfo.getType();
                        if (trace) {
                            log.trace((Object)("Obtained for event " + eventName + " its payload class " + dstPayloadClass.getName() + " declared by the portlet meta data " + containerId));
                        }
                    } else if (trace) {
                        log.trace((Object)("No type declared for event " + eventName + " declared by the portlet meta data " + containerId));
                    }
                }
                if (dstPayloadClass == null) {
                    if (trace) {
                        log.trace((Object)("No event meta data declared by portlet " + containerId + " for event " + eventName + " will attempty " + " to load same class name from the application " + applicationId + " classloader"));
                    }
                    try {
                        dstPayloadClass = applicationClassLoader.loadClass(srcPayloadClassName);
                        if (trace) {
                            log.trace((Object)("Obtained matching event class " + dstPayloadClass.getName() + " in application " + applicationId + " for event " + eventName));
                        }
                    }
                    catch (ClassNotFoundException e) {
                        return new ErrorResponse("The application " + applicationId + " does not have access to the event payload class" + srcPayloadClassName, e);
                    }
                    catch (NoClassDefFoundError e) {
                        return new ErrorResponse("The application " + applicationId + " does not have access to the event payload class" + srcPayloadClassName, e);
                    }
                }
                if (dstPayloadClass != srcPayload.getClass()) {
                    if (trace) {
                        log.trace((Object)("Need to convert event payload from class " + srcPayloadClassName + " to " + dstPayloadClass.getName()));
                    }
                    try {
                        dstPayload = IOTools.clone((Serializable)srcPayload, (ClassLoader)applicationClassLoader);
                    }
                    catch (ClassNotFoundException e) {
                        return new ErrorResponse("Could not convert the event payload from class " + srcPayloadClassName + " to class " + dstPayloadClass.getName(), e);
                    }
                    catch (IOException e) {
                        return new ErrorResponse("Could not convert the event payload from class " + srcPayloadClassName + " to class " + dstPayloadClass.getName(), e);
                    }
                } else {
                    dstPayload = srcPayload;
                }
            }
            eventInvocation.setPayload(dstPayload);
            try {
                PortletInvocationResponse portletInvocationResponse = super.invoke(invocation);
                return portletInvocationResponse;
            }
            finally {
                eventInvocation.setPayload(srcPayload);
            }
        }
        return super.invoke(invocation);
    }
}

