/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.text;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.jboss.portal.common.text.EncodingException;

public interface CharToByteEncoder {
    public static final byte[] EMPTY = new byte[0];

    public byte[] encode(char var1) throws EncodingException;

    public static class Generic
    implements CharToByteEncoder {
        public static final Generic UTF8 = new Generic("UTF8");
        private final CharsetEncoder encoder;
        private final CharBuffer in;
        private final ByteBuffer out;
        private final byte[][] arrays = new byte[][]{new byte[0], new byte[1], new byte[2], new byte[3], new byte[4], new byte[5]};

        public Generic(Charset charset) {
            this.encoder = charset.newEncoder();
            this.in = CharBuffer.allocate(1);
            this.out = ByteBuffer.allocate(100);
        }

        public Generic(String encoding) {
            this(Charset.forName(encoding));
        }

        public byte[] encode(char c) throws EncodingException {
            switch (Character.getType(c)) {
                case 18: 
                case 19: {
                    return EMPTY;
                }
            }
            if (this.encoder.canEncode(c)) {
                this.in.rewind();
                this.out.rewind();
                this.in.put(0, c);
                this.encoder.reset();
                this.encoder.encode(this.in, this.out, true);
                this.encoder.flush(this.out);
                int length = this.out.position();
                byte[] bytes = this.arrays[length];
                System.arraycopy(this.out.array(), 0, bytes, 0, length);
                return bytes;
            }
            return EMPTY;
        }
    }
}

