/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.utils;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.utils.Process;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Utility {
    private static int myAddr = 0;
    private static Uid processUid = null;
    private static Process processHandle = null;
    private static final String hexStart = "0x";
    private static final String defaultProcessId = "com.arjuna.ats.internal.arjuna.utils.SocketProcessId";

    public static String intToHexString(int number) throws NumberFormatException {
        return Integer.toString(number, 16);
    }

    public static int hexStringToInt(String s) throws NumberFormatException {
        boolean isNeg;
        String toUse = s;
        if (s.startsWith(hexStart)) {
            toUse = s.substring(hexStart.length());
        }
        String lastString = toUse.substring(toUse.length() - 1);
        if (toUse.substring(0, 1).equals("-")) {
            toUse = "-0" + toUse.substring(1, toUse.length() - 1);
            isNeg = true;
        } else {
            toUse = "0" + toUse.substring(0, toUse.length() - 1);
            isNeg = false;
        }
        Integer i = Integer.valueOf(toUse, 16);
        int val = i;
        val <<= 4;
        val = isNeg ? (val -= Integer.valueOf(lastString, 16).intValue()) : (val += Integer.valueOf(lastString, 16).intValue());
        return val;
    }

    public static String longToHexString(long number) throws NumberFormatException {
        return Long.toString(number, 16);
    }

    public static long hexStringToLong(String s) throws NumberFormatException {
        boolean isNeg;
        String toUse = s;
        if (s.startsWith(hexStart)) {
            toUse = s.substring(hexStart.length());
        }
        String lastString = toUse.substring(toUse.length() - 1);
        if (toUse.substring(0, 1).equals("-")) {
            toUse = "-0" + toUse.substring(1, toUse.length() - 1);
            isNeg = true;
        } else {
            toUse = "0" + toUse.substring(0, toUse.length() - 1);
            isNeg = false;
        }
        Long i = Long.valueOf(toUse, 16);
        long val = i;
        val <<= 4;
        val = isNeg ? (val -= Long.valueOf(lastString, 16).longValue()) : (val += Long.valueOf(lastString, 16).longValue());
        return val;
    }

    public static synchronized int hostInetAddr() throws UnknownHostException {
        if (myAddr == 0) {
            InetAddress addr = InetAddress.getLocalHost();
            byte[] b = addr.getAddress();
            for (int i = 0; i < b.length; ++i) {
                int l = 0x7F & b[i];
                myAddr = myAddr << 8 | (l += 0x80 & b[i]);
            }
        }
        return myAddr;
    }

    public static final int getpid() {
        Process handle = Utility.getProcess();
        return handle == null ? -1 : handle.getpid();
    }

    public static final synchronized Uid getProcessUid() {
        if (processUid == null) {
            processUid = new Uid();
        }
        return processUid;
    }

    public static final boolean isWindows() {
        String os = arjPropertyManager.propertyManager.getProperty("os.name");
        return "WIN32".equals(os) || os.indexOf("Windows") != -1;
    }

    public static final void setProcess(Process p) {
        processHandle = p;
    }

    public static final Process getDefaultProcess() {
        try {
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(defaultProcessId);
            return (Process)c.newInstance();
        }
        catch (Exception e) {
            tsLogger.arjLoggerI18N.warn("Utility_1", (Throwable)e);
            return null;
        }
    }

    private static final Process getProcess() {
        if (processHandle == null) {
            processHandle = Utility.getDefaultProcess();
        }
        return processHandle;
    }
}

