/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jdbc.drivers.modifiers;

import com.arjuna.ats.internal.jdbc.drivers.modifiers.ConnectionModifier;
import com.arjuna.ats.jta.TransactionManager;
import com.arjuna.ats.jta.exceptions.NotImplementedException;
import com.arjuna.ats.jta.xa.XAModifier;
import com.arjuna.ats.jta.xa.XidImple;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;
import oracle.jdbc.xa.OracleXid;

public class oracle_jndi
implements XAModifier,
ConnectionModifier {
    private boolean _reuseConnection = false;

    public String initialise(String dbName) {
        int index = dbName.indexOf("reuseconnection=true");
        int end = "reuseconnection=true".length();
        if (index != -1) {
            this._reuseConnection = false;
        } else {
            index = dbName.indexOf("reuseconnection=false");
            end = "reuseconnection=false".length();
        }
        if (index != 0) {
            return dbName;
        }
        return dbName.substring(end + 1);
    }

    public Xid createXid(XidImple xid) throws SQLException, NotImplementedException {
        try {
            return new OracleXid(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
    }

    public int xaStartParameters(int level) throws SQLException, NotImplementedException {
        return level;
    }

    public XAConnection getConnection(XAConnection conn) throws SQLException, NotImplementedException {
        return null;
    }

    public boolean supportsMultipleConnections() throws SQLException, NotImplementedException {
        return true;
    }

    public void setIsolationLevel(Connection conn, int level) throws SQLException, NotImplementedException {
        javax.transaction.TransactionManager tm = TransactionManager.transactionManager();
        Transaction tx = null;
        try {
            tx = tm.getTransaction();
        }
        catch (SystemException se) {
            // empty catch block
        }
        if (tx != null && conn.getTransactionIsolation() != level) {
            conn.setTransactionIsolation(level);
        }
    }
}

