/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.ldap;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.jboss.logging.Logger;
import org.jboss.portal.common.util.Tools;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.NoSuchUserException;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.ldap.LDAPUserImpl;
import org.jboss.portal.identity.ldap.LDAPUserModuleImpl;

public class LDAPExtUserModuleImpl
extends LDAPUserModuleImpl {
    private static final Logger log = Logger.getLogger(LDAPExtUserModuleImpl.class);

    public User findUserByUserName(String userName) throws IdentityException, IllegalArgumentException, NoSuchUserException {
        Context ctx = null;
        try {
            log.debug((Object)("findUserByUserName(): username = " + userName));
            if (userName == null) {
                throw new IdentityException("User name canot be null");
            }
            String filter = this.getUserSearchFilter();
            log.debug((Object)("Search filter: " + filter));
            Object[] filterArgs = new Object[]{userName};
            List sr = this.searchUsers(filter, filterArgs);
            if (sr.size() > 1) {
                throw new IdentityException("Found more than one user with id: " + userName + "" + "Posible data inconsistency");
            }
            SearchResult res = (SearchResult)sr.iterator().next();
            ctx = (Context)res.getObject();
            String dn = ctx.getNameInNamespace();
            LDAPUserImpl user = this.createUserInstance(res.getAttributes(), dn);
            ctx.close();
            LDAPUserImpl lDAPUserImpl = user;
            return lDAPUserImpl;
        }
        catch (NoSuchElementException e) {
            log.debug((Object)("No user found with name: " + userName), (Throwable)e);
        }
        catch (NamingException e) {
            throw new IdentityException("User search failed.", e);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
        throw new NoSuchUserException("No user found with name: " + userName);
    }

    public User createUser(String userName, String password) throws IdentityException, IllegalArgumentException {
        throw new UnsupportedOperationException("User management is not supported in this implementation of UserModule");
    }

    public User createUser(String userName, String password, String realEmail) throws IdentityException, IllegalArgumentException {
        throw new UnsupportedOperationException("User management is not supported in this implementation of UserModule");
    }

    public void removeUser(Object id) throws IdentityException, IllegalArgumentException {
        throw new UnsupportedOperationException("User management is not supported in this implementation of UserModule");
    }

    public Set findUsers(int offset, int limit) throws IdentityException, IllegalArgumentException {
        return this.findUsersFilteredByUserName("*", offset, limit);
    }

    public Set findUsersFilteredByUserName(String filter, int offset, int limit) throws IdentityException, IllegalArgumentException {
        List uf = new LinkedList();
        try {
            log.debug((Object)("findUserFilteredByUserName(): filter = " + filter));
            if (filter == null) {
                throw new IllegalArgumentException("Null user name filter");
            }
            log.info((Object)"Current implementation of findUsersFilteredByUserName returns all users and is not \"offset\" and \"limit\" sensitive ");
            if (filter.length() == 0) {
                filter = "*";
            } else if (filter.length() != 1 || !filter.equals("*")) {
                filter = "*" + filter + "*";
            }
            String ldap_filter = this.getUserSearchFilter();
            ldap_filter = ldap_filter.replaceAll("\\{0\\}", filter);
            log.debug((Object)("Search filter: " + ldap_filter));
            uf = this.searchUsers(ldap_filter, null);
            int size = uf.size();
            if (offset == 0 && size <= limit) {
                return this.processUsers(uf);
            }
            Collections.sort(uf, new LDAPUserModuleImpl.UserEntryComparator(this));
            if (offset + limit <= size) {
                return this.processUsers(uf.subList(offset, offset + limit));
            }
            if (offset >= size) {
                return new HashSet();
            }
            return this.processUsers(uf.subList(offset, size));
        }
        catch (NoSuchElementException e) {
            log.debug((Object)"No users found", (Throwable)e);
        }
        catch (Throwable e) {
            throw new IdentityException("User search failed.", e);
        }
        return null;
    }

    public int getUserCount() throws IdentityException, IllegalArgumentException {
        try {
            String filter = this.getUserSearchFilter();
            log.debug((Object)("Search filter: " + filter));
            filter = filter.replaceAll("\\{0\\}", "*");
            List sr = this.searchUsers(filter, null);
            return sr.size();
        }
        catch (NoSuchElementException e) {
            log.debug((Object)"No users found", (Throwable)e);
        }
        catch (Exception e) {
            throw new IdentityException("User search failed.", e);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List searchUsers(String filter, Object[] filterArgs) throws NamingException, IdentityException {
        LdapContext ldapContext = this.getConnectionContext().createInitialContext();
        NamingEnumeration<SearchResult> results = null;
        try {
            Object filterArg;
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningObjFlag(true);
            controls.setTimeLimit(this.getSearchTimeLimit());
            log.debug((Object)("Search filter: " + filter));
            if (log.isDebugEnabled() && filterArgs != null) {
                for (int i = 0; i < filterArgs.length; ++i) {
                    filterArg = filterArgs[i];
                    log.debug((Object)("Search filterArg: {" + i + "}: " + filterArg));
                }
            }
            log.debug((Object)("Search ctx: " + this.getUserSearchCtxDNs()));
            Set userCtxs = this.getUserSearchCtxDNs();
            if (userCtxs.size() == 1) {
                results = filterArgs == null ? ldapContext.search(this.getUserSearchCtxDN(), filter, controls) : ldapContext.search(this.getUserSearchCtxDN(), filter, filterArgs, controls);
                filterArg = Tools.toList(results);
                return filterArg;
            }
            LinkedList merged = new LinkedList();
            for (String userCtx : userCtxs) {
                results = filterArgs == null ? ldapContext.search(userCtx, filter, controls) : ldapContext.search(userCtx, filter, filterArgs, controls);
                merged.addAll(Tools.toList(results));
                results.close();
            }
            LinkedList linkedList = merged;
            return linkedList;
        }
        finally {
            if (results != null) {
                results.close();
            }
            ldapContext.close();
        }
    }

    protected Set getUserSearchCtxDNs() throws IdentityException {
        Set searchCtx = this.getIdentityConfiguration().getValues("common", "userCtxDN");
        if (searchCtx == null || searchCtx.size() == 0) {
            throw new IdentityException("userCtxDN missing in configuration");
        }
        return searchCtx;
    }
}

