/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.cms;

import org.apache.commons.lang.StringUtils;

public class CMSException
extends Exception {
    private static final long serialVersionUID = 1L;
    public static final int ERROR_FORBIDDEN = 1;
    public static final int ERROR_UNAVAILAIBLE = 2;
    public static final int ERROR_NOTFOUND = 3;
    private final int errorCode;

    public CMSException(Throwable e) {
        super(e);
        this.errorCode = 0;
    }

    public CMSException(int errorCode) {
        this.errorCode = errorCode;
    }

    public CMSException(String message) {
        super(message);
        this.errorCode = 0;
    }

    public CMSException(String message, Throwable e) {
        super(message, e);
        this.errorCode = 0;
    }

    @Override
    public String getMessage() {
        String causeMessage = super.getMessage();
        StringBuilder message = new StringBuilder();
        if (this.errorCode > 0) {
            switch (this.errorCode) {
                case 1: {
                    message.append("Forbidden (403)");
                    break;
                }
                case 3: {
                    message.append("Not found (404)");
                }
            }
        }
        if (message.length() > 0 && causeMessage != null) {
            message.append(" - ");
        }
        message.append(StringUtils.trimToEmpty((String)causeMessage));
        return message.toString();
    }

    public int getErrorCode() {
        return this.errorCode;
    }
}

