/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.core.CollectionAndSequence;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.InvalidPropertyException;
import freemarker.ext.beans.MethodMap;
import freemarker.ext.beans.OverloadedMethodModel;
import freemarker.ext.beans.SimpleMethodModel;
import freemarker.ext.util.ModelFactory;
import freemarker.ext.util.WrapperTemplateModel;
import freemarker.log.Logger;
import freemarker.template.AdapterTemplateModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateScalarModel;
import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BeanModel
implements TemplateHashModelEx,
AdapterTemplateModel,
WrapperTemplateModel {
    private static final Logger logger = Logger.getLogger("freemarker.beans");
    protected final Object object;
    protected final BeansWrapper wrapper;
    private static final TemplateModel UNKNOWN = new SimpleScalar("UNKNOWN");
    static final ModelFactory FACTORY = new ModelFactory(){

        public TemplateModel create(Object object, ObjectWrapper wrapper) {
            return new BeanModel(object, (BeansWrapper)wrapper);
        }
    };
    private final HashMap memberMap = new HashMap();

    public BeanModel(Object object, BeansWrapper wrapper) {
        this.object = object;
        this.wrapper = wrapper;
        if (object == null) {
            return;
        }
        wrapper.introspectClass(object.getClass());
    }

    public TemplateModel get(String key) throws TemplateModelException {
        Class<?> clazz = this.object.getClass();
        Map classInfo = this.wrapper.getClassKeyMap(clazz);
        TemplateModel retval = null;
        try {
            if (this.wrapper.isMethodsShadowItems()) {
                Object fd = classInfo.get(key);
                retval = fd != null ? this.invokeThroughDescriptor(fd, classInfo) : this.invokeGenericGet(classInfo, clazz, key);
            } else {
                TemplateModel nullModel;
                TemplateModel model = this.invokeGenericGet(classInfo, clazz, key);
                if (model != (nullModel = this.wrapper.wrap(null)) && model != UNKNOWN) {
                    return model;
                }
                Object fd = classInfo.get(key);
                if (fd != null && (retval = this.invokeThroughDescriptor(fd, classInfo)) == UNKNOWN && model == nullModel) {
                    retval = nullModel;
                }
            }
            if (retval == UNKNOWN) {
                if (this.wrapper.isStrict()) {
                    throw new InvalidPropertyException("No such bean property: " + key);
                }
                if (logger.isDebugEnabled()) {
                    this.logNoSuchKey(key, classInfo);
                }
                retval = this.wrapper.wrap(null);
            }
            return retval;
        }
        catch (TemplateModelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateModelException("get(" + key + ") failed on " + "instance of " + this.object.getClass().getName(), e);
        }
    }

    private void logNoSuchKey(String key, Map keyMap) {
        logger.debug("Key '" + key + "' was not found on instance of " + this.object.getClass().getName() + ". Introspection information for " + "the class is: " + keyMap);
    }

    protected boolean hasPlainGetMethod() {
        return this.wrapper.getClassKeyMap(this.object.getClass()).get(BeansWrapper.GENERIC_GET_KEY) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TemplateModel invokeThroughDescriptor(Object desc, Map classInfo) throws IllegalAccessException, InvocationTargetException, TemplateModelException {
        TemplateModel member = null;
        HashMap hashMap = this.memberMap;
        synchronized (hashMap) {
            member = (TemplateModel)this.memberMap.get(desc);
        }
        if (member != null) {
            return member;
        }
        TemplateModel retval = UNKNOWN;
        if (desc instanceof IndexedPropertyDescriptor) {
            Method readMethod = ((IndexedPropertyDescriptor)desc).getIndexedReadMethod();
            retval = member = new SimpleMethodModel(this.object, readMethod, BeansWrapper.getArgTypes(classInfo, readMethod), this.wrapper);
        } else if (desc instanceof PropertyDescriptor) {
            PropertyDescriptor pd = (PropertyDescriptor)desc;
            retval = this.wrapper.invokeMethod(this.object, pd.getReadMethod(), null);
        } else if (desc instanceof Field) {
            retval = this.wrapper.wrap(((Field)desc).get(this.object));
        } else if (desc instanceof Method) {
            Method method = (Method)desc;
            retval = member = new SimpleMethodModel(this.object, method, BeansWrapper.getArgTypes(classInfo, method), this.wrapper);
        } else if (desc instanceof MethodMap) {
            retval = member = new OverloadedMethodModel(this.object, (MethodMap)desc, this.wrapper);
        }
        if (member != null) {
            HashMap hashMap2 = this.memberMap;
            synchronized (hashMap2) {
                this.memberMap.put(desc, member);
            }
        }
        return retval;
    }

    protected TemplateModel invokeGenericGet(Map keyMap, Class clazz, String key) throws IllegalAccessException, InvocationTargetException, TemplateModelException {
        Method genericGet = (Method)keyMap.get(BeansWrapper.GENERIC_GET_KEY);
        if (genericGet == null) {
            return UNKNOWN;
        }
        return this.wrapper.invokeMethod(this.object, genericGet, new Object[]{key});
    }

    protected TemplateModel wrap(Object obj) throws TemplateModelException {
        return this.wrapper.getOuterIdentity().wrap(obj);
    }

    protected Object unwrap(TemplateModel model) throws TemplateModelException {
        return this.wrapper.unwrap(model);
    }

    public boolean isEmpty() {
        if (this.object instanceof String) {
            return ((String)this.object).length() == 0;
        }
        if (this.object instanceof Collection) {
            return ((Collection)this.object).isEmpty();
        }
        if (this.object instanceof Map) {
            return ((Map)this.object).isEmpty();
        }
        return this.object == null || Boolean.FALSE.equals(this.object);
    }

    public Object getAdaptedObject(Class hint) {
        return this.object;
    }

    public Object getWrappedObject() {
        return this.object;
    }

    public int size() {
        return this.wrapper.keyCount(this.object.getClass());
    }

    public TemplateCollectionModel keys() {
        return new CollectionAndSequence(new SimpleSequence(this.keySet(), this.wrapper));
    }

    public TemplateCollectionModel values() throws TemplateModelException {
        ArrayList<TemplateModel> values = new ArrayList<TemplateModel>(this.size());
        TemplateModelIterator it = this.keys().iterator();
        while (it.hasNext()) {
            String key = ((TemplateScalarModel)it.next()).getAsString();
            values.add(this.get(key));
        }
        return new CollectionAndSequence(new SimpleSequence(values, this.wrapper));
    }

    public String toString() {
        return this.object.toString();
    }

    protected Set keySet() {
        return this.wrapper.keySet(this.object.getClass());
    }
}

