/*
 * Decompiled with CFR 0.152.
 */
package javax.portlet.faces;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericFacesPortlet
extends GenericPortlet {
    private static final int EXTENDED_ATTR_PREFIX_LENGTH = "javax.portlet.faces.extension.".length();
    private static final String BRIDGE_SERVICE_CLASSPATH = "META-INF/services/javax.portlet.faces.Bridge";
    public static final String BRIDGE_CLASS = "javax.portlet.faces.BridgeImplClass";
    public static final String DEFAULT_CONTENT_TYPE = "javax.portlet.faces.defaultContentType";
    public static final String DEFAULT_CHARACTERSET_ENCODING = "javax.portlet.faces.defaultCharacterSetEncoding";
    private volatile String bridgeClassName = null;
    private volatile Class<? extends Bridge> facesBridgeClass;
    private volatile Bridge facesPortletBridge = null;
    private Map<String, String> viewIdMap;
    private static final String DEFAULT_VIEWID = "javax.portlet.faces.defaultViewId";
    private static final int DEFAULT_VIEW_ID_LENGTH = "javax.portlet.faces.defaultViewId".length() + 1;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        PortletContext portletContext = this.getPortletContext();
        String bridgeClassName = this.getBridgeClassName();
        try {
            this.facesBridgeClass = this.getClassLoader().loadClass(bridgeClassName).asSubclass(Bridge.class);
        }
        catch (ClassNotFoundException e) {
            throw new PortletException("Faces portlet Bridge implementation class not found", (Throwable)e);
        }
        String portletName = this.getPortletName();
        Boolean isPreserveActionParams = this.getPreserveActionParameters();
        portletContext.setAttribute("javax.portlet.faces." + portletName + "." + "preserveActionParams", (Object)isPreserveActionParams);
        List<String> attrsList = this.getExcludedRequestAttributes();
        if (null != attrsList) {
            portletContext.setAttribute("javax.portlet.faces." + portletName + "." + "excludedRequestAttributes", attrsList);
        }
        Enumeration configNames = config.getInitParameterNames();
        while (configNames.hasMoreElements()) {
            int i;
            String name = (String)configNames.nextElement();
            if (!name.startsWith("javax.portlet.faces.extension.") || (i = name.lastIndexOf(46)) <= EXTENDED_ATTR_PREFIX_LENGTH + 2) continue;
            String attribute = name.substring(i);
            String preffix = name.substring(EXTENDED_ATTR_PREFIX_LENGTH, i + 1);
            String extensionAttributeName = "javax.portlet.faces.extension." + preffix + portletName + attribute;
            portletContext.setAttribute(extensionAttributeName, (Object)config.getInitParameter(name));
        }
        Map<String, String> viewIdMap = this.getDefaultViewIdMap();
        this.getPortletContext().setAttribute("javax.portlet.faces." + portletName + "." + "defaultViewIdMap", viewIdMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String calculateBridgeClassName(PortletContext portletContext) throws PortletException {
        ClassLoader loader;
        InputStream stream;
        String bridgeClassName = portletContext.getInitParameter(BRIDGE_CLASS);
        if (bridgeClassName == null && null != (stream = (loader = this.getClassLoader()).getResourceAsStream(BRIDGE_SERVICE_CLASSPATH))) {
            try {
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    reader = new BufferedReader(new InputStreamReader(stream));
                }
                bridgeClassName = reader.readLine();
                if (null != bridgeClassName) {
                    bridgeClassName = bridgeClassName.trim();
                }
            }
            catch (IOException e) {
                try {
                    stream.close();
                }
                catch (IOException e2) {
                    throw new PortletException("Error to close input stream for a resource META-INF/services/javax.portlet.faces.Bridge");
                }
            }
            catch (SecurityException e) {
                try {
                    stream.close();
                }
                catch (IOException e3) {
                    throw new PortletException("Error to close input stream for a resource META-INF/services/javax.portlet.faces.Bridge");
                }
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new PortletException("Error to close input stream for a resource META-INF/services/javax.portlet.faces.Bridge");
                }
            }
        }
        if (null == bridgeClassName) {
            throw new PortletException("Can't detect bridge implementation class name");
        }
        return bridgeClassName;
    }

    public List<String> getExcludedRequestAttributes() {
        ArrayList<String> attrsList = null;
        String excludedAttrs = this.getPortletConfig().getInitParameter("javax.portlet.faces.excludedRequestAttributes");
        if (null != excludedAttrs) {
            String[] atrs = excludedAttrs.split(",");
            attrsList = new ArrayList<String>(atrs.length);
            for (String string : atrs) {
                attrsList.add(string);
            }
        }
        return attrsList;
    }

    public String getResponseContentType(PortletRequest request) {
        String contentType = this.getPortletConfig().getPortletContext().getInitParameter(DEFAULT_CONTENT_TYPE);
        if (contentType == null) {
            contentType = request.getResponseContentType();
        }
        return contentType;
    }

    public String getResponseCharacterSetEncoding(PortletRequest request) {
        return this.getPortletConfig().getPortletContext().getInitParameter(DEFAULT_CHARACTERSET_ENCODING);
    }

    public Boolean getPreserveActionParameters() {
        String preserveActionParams = this.getPortletConfig().getInitParameter("javax.portlet.faces.preserveActionParams");
        Boolean isPreserveActionParams = Boolean.valueOf(preserveActionParams);
        return isPreserveActionParams;
    }

    protected void doDispatch(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletMode mode = request.getPortletMode();
        if (mode == PortletMode.VIEW || mode == PortletMode.EDIT || mode == PortletMode.HELP) {
            super.doDispatch(request, response);
        } else {
            this.doFacesDispatch(request, response);
        }
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.doFacesDispatch(request, response);
    }

    protected void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.doFacesDispatch(request, response);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.doFacesDispatch(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        Bridge bridge = this.getFacesPortletBridge();
        try {
            bridge.doFacesRequest(request, response);
        }
        catch (BridgeException e) {
            throw new PortletException("Error process faces request", (Throwable)((Object)e));
        }
    }

    void doFacesDispatch(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String defaultViewId = this.getDefaultViewIdMap().get(request.getPortletMode().toString());
        if (null != defaultViewId && !request.getWindowState().equals((Object)WindowState.MINIMIZED)) {
            Bridge bridge = this.getFacesPortletBridge();
            String responseContentType = this.getResponseContentType((PortletRequest)request);
            if (null != responseContentType) {
                StringBuilder contentType = new StringBuilder(responseContentType);
                String characterSetEncoding = this.getResponseCharacterSetEncoding((PortletRequest)request);
                if (null != characterSetEncoding) {
                    contentType.append(';').append(characterSetEncoding);
                }
                response.setContentType(contentType.toString());
            }
            try {
                bridge.doFacesRequest(request, response);
            }
            catch (BridgeException e) {
                throw new PortletException("Error process faces request", (Throwable)((Object)e));
            }
        }
    }

    public String getBridgeClassName() throws PortletException {
        if (null == this.bridgeClassName) {
            this.bridgeClassName = this.calculateBridgeClassName(this.getPortletContext());
        }
        return this.bridgeClassName;
    }

    private ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (null == classLoader) {
            classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        return classLoader;
    }

    public Map<String, String> getDefaultViewIdMap() {
        if (null == this.viewIdMap) {
            this.viewIdMap = this.calculateDefaultViewIdMap();
        }
        return this.viewIdMap;
    }

    private Map<String, String> calculateDefaultViewIdMap() {
        HashMap<String, String> viewIdMap = new HashMap<String, String>();
        PortletConfig portletConfig = this.getPortletConfig();
        Enumeration configNames = portletConfig.getInitParameterNames();
        while (configNames.hasMoreElements()) {
            String name = (String)configNames.nextElement();
            if (!name.startsWith(DEFAULT_VIEWID)) continue;
            viewIdMap.put(name.substring(DEFAULT_VIEW_ID_LENGTH), portletConfig.getInitParameter(name));
        }
        return viewIdMap;
    }

    public void destroy() {
        this.bridgeClassName = null;
        if (null != this.facesPortletBridge) {
            this.facesPortletBridge.destroy();
            this.facesPortletBridge = null;
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bridge getFacesPortletBridge() throws PortletException {
        if (null == this.facesPortletBridge) {
            GenericFacesPortlet genericFacesPortlet = this;
            synchronized (genericFacesPortlet) {
                if (null == this.facesPortletBridge) {
                    try {
                        this.facesPortletBridge = this.facesBridgeClass.newInstance();
                        this.facesPortletBridge.init(this.getPortletConfig());
                    }
                    catch (InstantiationException e) {
                        throw new PortletException("Error on create instance of a JSF Portlet Bridge", (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        throw new PortletException("IllegalAccess on create instance of a JSF Portlet Bridge", (Throwable)e);
                    }
                    catch (BridgeException e) {
                        throw new PortletException("Bridge initialization error", (Throwable)((Object)e));
                    }
                }
            }
        }
        return this.facesPortletBridge;
    }
}

