/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.widget.google.provider;

import java.io.ByteArrayInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.logging.Logger;
import org.jboss.portal.common.i18n.LocalizedString;
import org.jboss.portal.common.net.URLTools;
import org.jboss.portal.common.xml.XMLTools;
import org.jboss.portal.widget.exceptions.WidgetException;
import org.jboss.portal.widget.exceptions.WidgetFetchException;
import org.jboss.portal.widget.exceptions.WidgetMetaDataParseException;
import org.jboss.portal.widget.exceptions.WidgetNotSupportedException;
import org.jboss.portal.widget.google.info.GGPreferenceInfo;
import org.jboss.portal.widget.google.info.GGPreferencesInfo;
import org.jboss.portal.widget.google.info.GGWidgetInfo;
import org.jboss.portal.widget.google.type.BoolType;
import org.jboss.portal.widget.google.type.DataType;
import org.jboss.portal.widget.google.type.EnumType;
import org.jboss.portal.widget.google.type.HiddenType;
import org.jboss.portal.widget.google.type.ListType;
import org.jboss.portal.widget.google.type.LocationType;
import org.jboss.portal.widget.google.type.StringType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GGWidgetInfoBuilder {
    private static final Logger log = Logger.getLogger(GGWidgetInfoBuilder.class);
    private final URL url;

    public GGWidgetInfoBuilder(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("No null URL");
        }
        this.url = url;
    }

    public URL getURL() {
        return this.url;
    }

    public GGWidgetInfo create() throws WidgetException, MalformedURLException {
        Object value;
        Document doc;
        DocumentBuilderFactory factory;
        long millis = System.currentTimeMillis();
        byte[] bytes = this.obtainWidget(this.url);
        if (bytes == null) {
            throw new WidgetFetchException("Could not retreive widget data.");
        }
        try {
            factory = XMLTools.getDocumentBuilderFactory();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(new ByteArrayInputStream(bytes));
        }
        catch (Exception e) {
            throw new WidgetMetaDataParseException("Could not parse widget document.");
        }
        Element moduleElt = doc.getDocumentElement();
        HashMap<String, LocalizedString> messagesBundle = new HashMap<String, LocalizedString>();
        Iterator modulePrefsEltIterator = XMLTools.getChildrenIterator((Element)moduleElt, (String)"ModulePrefs");
        if (modulePrefsEltIterator.hasNext()) {
            Element modulePrefsElt = (Element)modulePrefsEltIterator.next();
            Iterator localeEltIterator = XMLTools.getChildrenIterator((Element)modulePrefsElt, (String)"Locale");
            HashMap messages = new HashMap();
            while (localeEltIterator.hasNext()) {
                Document bundleDoc;
                Element localeElt = (Element)localeEltIterator.next();
                String langAttr = localeElt.getAttribute("lang");
                String countryAttr = localeElt.getAttribute("country");
                String messagesAttr = localeElt.getAttribute("messages");
                if (langAttr == null || langAttr.length() == 0) {
                    langAttr = "en";
                }
                Locale locale = countryAttr == null || countryAttr.length() == 0 ? new Locale(langAttr) : new Locale(langAttr, countryAttr);
                URL bundleURL = new URL(this.url, messagesAttr);
                byte[] bundleBytes = this.obtainLocaleBundle(bundleURL);
                if (bundleBytes == null) continue;
                try {
                    DocumentBuilder bundleDocBuilder = factory.newDocumentBuilder();
                    bundleDoc = bundleDocBuilder.parse(new ByteArrayInputStream(bundleBytes));
                }
                catch (Exception e) {
                    throw new WidgetMetaDataParseException("Could not parse bundles.");
                }
                Element messagebundleElt = bundleDoc.getDocumentElement();
                Iterator messagesEltIterator = XMLTools.getChildrenIterator((Element)messagebundleElt, (String)"msg");
                while (messagesEltIterator.hasNext()) {
                    Map<Locale, String> entries;
                    Element msgElt = (Element)messagesEltIterator.next();
                    String name = msgElt.getAttribute("name");
                    value = new StringBuffer();
                    NodeList nodes = msgElt.getChildNodes();
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node n = nodes.item(i);
                        if (n.getNodeType() != 3) continue;
                        ((StringBuffer)value).append(n.getNodeValue());
                    }
                    if (!messages.containsKey(name)) {
                        entries = new HashMap();
                        messages.put(name, entries);
                    } else {
                        entries = (Map)messages.get(name);
                    }
                    entries.put(locale, ((StringBuffer)value).toString());
                }
            }
            for (String name : messages.keySet()) {
                Map entries = (Map)messages.get(name);
                messagesBundle.put(name, new LocalizedString(entries, Locale.ENGLISH));
            }
        } else {
            throw new WidgetMetaDataParseException("Could not parse widget meta data.");
        }
        ArrayList<GGPreferenceInfo> tmp = null;
        Iterator userPrefsEltIterator = XMLTools.getChildrenIterator((Element)moduleElt, (String)"UserPref");
        while (userPrefsEltIterator.hasNext()) {
            Element userPref = (Element)userPrefsEltIterator.next();
            String nameAttr = userPref.getAttribute("name");
            String displayNameAttr = userPref.getAttribute("display_name");
            String urlParamAttr = userPref.getAttribute("urlparam");
            String dataTypeAttr = userPref.getAttribute("datatype");
            String requiredAttr = userPref.getAttribute("required");
            String defaultValueAttr = userPref.getAttribute("default_value");
            if (urlParamAttr.length() > 0) {
                throw new WidgetNotSupportedException("urlparam not supported yet.");
            }
            DataType dataType = StringType.getInstance();
            if (dataTypeAttr.length() > 0) {
                int dataTypeOrdinal = DataType.parseDataTypeLiteral(dataTypeAttr);
                switch (dataTypeOrdinal) {
                    case 3: {
                        dataType = HiddenType.getInstance();
                        break;
                    }
                    case 1: {
                        dataType = BoolType.getInstance();
                        break;
                    }
                    case 0: {
                        dataType = StringType.getInstance();
                        break;
                    }
                    case 4: {
                        dataType = ListType.getInstance();
                        break;
                    }
                    case 2: {
                        ArrayList<Object> values = new ArrayList<Object>();
                        Iterator i = XMLTools.getChildrenIterator((Element)userPref, (String)"EnumValue");
                        while (i.hasNext()) {
                            Element enumValueElt = (Element)i.next();
                            String valueAttr = enumValueElt.getAttribute("value");
                            String displayValueAttr = enumValueElt.getAttribute("display_value");
                            value = new EnumType.Value(valueAttr, this.resolveLocalizedValue(displayValueAttr, messagesBundle));
                            values.add(value);
                        }
                        dataType = new EnumType(values);
                        break;
                    }
                    case 5: {
                        dataType = LocationType.getInstance();
                    }
                }
            }
            GGPreferenceInfo prefInfo = new GGPreferenceInfo(nameAttr, dataType, this.resolveLocalizedValue(displayNameAttr, messagesBundle), requiredAttr.length() > 0 ? Boolean.valueOf(requiredAttr) : false, defaultValueAttr.length() > 0 ? defaultValueAttr : null);
            if (tmp == null) {
                tmp = new ArrayList<GGPreferenceInfo>();
            }
            tmp.add(prefInfo);
        }
        GGPreferencesInfo prefsInfo = GGPreferencesInfo.EMPTY_PREFS;
        if (tmp != null) {
            prefsInfo = new GGPreferencesInfo(tmp);
        }
        if ((modulePrefsEltIterator = XMLTools.getChildrenIterator((Element)moduleElt, (String)"ModulePrefs")).hasNext()) {
            int height;
            Element modulePrefsElt = (Element)modulePrefsEltIterator.next();
            String titleAttr = modulePrefsElt.getAttribute("title");
            String directoryTitleAttr = modulePrefsElt.getAttribute("directory_title");
            String descriptionAttr = modulePrefsElt.getAttribute("description");
            String widthAttr = modulePrefsElt.getAttribute("width");
            String heightAttr = modulePrefsElt.getAttribute("height");
            LocalizedString title = this.resolveLocalizedStringValue(titleAttr, messagesBundle);
            LocalizedString directoryTitle = this.resolveLocalizedStringValue(directoryTitleAttr, messagesBundle);
            LocalizedString description = this.resolveLocalizedStringValue(descriptionAttr, messagesBundle);
            int width = widthAttr != null && widthAttr.length() > 0 ? Integer.parseInt(widthAttr) : 320;
            int n = height = heightAttr != null && heightAttr.length() > 0 ? Integer.parseInt(heightAttr) : 200;
            if (log.isDebugEnabled()) {
                log.debug((Object)("fetchting & building gadget: " + this.url.toString() + " took: " + NumberFormat.getInstance().format((double)(System.currentTimeMillis() - millis) / 1000.0)));
            }
            return new GGWidgetInfo(title, directoryTitle, description, width, height, prefsInfo);
        }
        throw new WidgetMetaDataParseException("Could parse widget meta data.");
    }

    private LocalizedString resolveLocalizedStringValue(String value, Map bundle) {
        if (value != null) {
            String name;
            if (value.startsWith("__MSG_") && bundle.containsKey(name = value.substring("__MSG_".length(), value.length() - 2))) {
                return (LocalizedString)bundle.get(name);
            }
            return new LocalizedString(value, Locale.ENGLISH);
        }
        return null;
    }

    private String resolveLocalizedValue(String value, Map bundle) {
        LocalizedString out = this.resolveLocalizedStringValue(value, bundle);
        if (out != null && !"".equals(out.getDefaultString())) {
            return out.getDefaultString();
        }
        return null;
    }

    protected byte[] obtainWidget(URL url) throws IllegalArgumentException {
        return this.obtainURL(url);
    }

    protected byte[] obtainLocaleBundle(URL url) throws IllegalArgumentException {
        return this.obtainURL(url);
    }

    private byte[] obtainURL(URL url) throws IllegalArgumentException {
        return URLTools.getContent((URL)url, (int)5000, (int)5000);
    }
}

