/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.wsdl.Extendable;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLService;

public class WSDLEndpoint
extends Extendable {
    private static final long serialVersionUID = 4991302339046047865L;
    private static final Logger log = Logger.getLogger(WSDLEndpoint.class);
    private final WSDLService wsdlService;
    private final QName name;
    private QName binding;
    private String address;

    public WSDLEndpoint(WSDLService wsdlService, QName name) {
        this.wsdlService = wsdlService;
        this.name = name;
    }

    public WSDLService getWsdlService() {
        return this.wsdlService;
    }

    public WSDLInterface getInterface() {
        WSDLInterface wsdlInterface = null;
        WSDLDefinitions wsdlDefinitions = this.wsdlService.getWsdlDefinitions();
        if (this.wsdlService.getInterfaceName() != null) {
            QName qname = this.wsdlService.getInterfaceName();
            wsdlInterface = wsdlDefinitions.getInterface(qname);
        } else {
            WSDLBinding wsdlBinding = wsdlDefinitions.getBinding(this.binding);
            if (wsdlBinding == null) {
                throw new WSException("Cannot obtain the binding: " + this.binding);
            }
            if (wsdlBinding.getInterfaceName() != null) {
                QName qname = wsdlBinding.getInterfaceName();
                wsdlInterface = wsdlDefinitions.getInterface(qname);
            }
        }
        if (wsdlInterface == null) {
            throw new WSException("Cannot obtain the interface associated with this endpoint: " + this.name);
        }
        return wsdlInterface;
    }

    public QName getName() {
        return this.name;
    }

    public QName getBinding() {
        return this.binding;
    }

    public void setBinding(QName binding) {
        log.trace((Object)("setBinding: " + binding));
        this.binding = binding;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
}

