/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.faces.gui;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.jboss.portal.common.util.ParameterValidation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanContext {
    public static final String STATUS = "status";
    private static final String RESOURCE_NAME = "Resource";
    private static final String UNEXPECTED_ERROR = "bean_support_unexpected_error";
    private static final String CAUSE = "bean_support_cause";
    private static final String CURRENT_PLACEHOLDER = "###";

    public abstract String getParameter(String var1);

    protected abstract void createMessage(String var1, String var2, Object var3);

    protected abstract Object getErrorSeverity();

    protected abstract Object getInfoSeverity();

    protected abstract Locale getLocale();

    public void createErrorMessage(String localizedMessageId, Object ... params) {
        this.createLocalizedMessage(STATUS, localizedMessageId, this.getErrorSeverity(), params);
    }

    public void createTargetedErrorMessage(String target, String localizedMessageId, Object ... params) {
        this.createLocalizedMessage(target, localizedMessageId, this.getErrorSeverity(), params);
    }

    protected void createLocalizedMessage(String target, String localizedMessageId, Object severity, Object ... params) {
        this.createMessage(target, this.getMessageFromBundle(localizedMessageId, params), severity);
    }

    public String getMessageFromBundle(String localizedMessageId, Object ... params) {
        return BeanContext.getLocalizedMessage(localizedMessageId, this.getLocale(), params);
    }

    public static String getLocalizedMessage(String localizationKey, Locale locale, Object ... params) {
        ResourceBundle rb = ResourceBundle.getBundle(RESOURCE_NAME, locale);
        return MessageFormat.format(rb.getString(localizationKey), params);
    }

    public void createErrorMessageFrom(Exception e) {
        this.createErrorMessageFrom(STATUS, e);
    }

    public void createErrorMessageFrom(String target, Exception e) {
        Throwable cause = e.getCause();
        String localizedMessage = this.getLocalizedMessageOrExceptionName(e);
        String message = localizedMessage + (cause != null ? "\n" + this.getMessageFromBundle(CAUSE, new Object[0]) + this.getLocalizedMessageOrExceptionName(cause) : "");
        this.createMessage(target, message, this.getErrorSeverity());
    }

    private String getLocalizedMessageOrExceptionName(Throwable e) {
        String localizedMessage = e.getLocalizedMessage();
        if (localizedMessage == null) {
            localizedMessage = this.getMessageFromBundle(UNEXPECTED_ERROR, new Object[0]) + e.getClass().getName();
        }
        return localizedMessage;
    }

    protected void createInfoMessage(String target, String localizedMessageId) {
        this.createLocalizedMessage(target, localizedMessageId, this.getInfoSeverity(), new Object[0]);
    }

    public void createInfoMessage(String localizedMessageId) {
        this.createInfoMessage(STATUS, localizedMessageId);
    }

    public void removeFromSession(String name, String ... otherNames) {
        Map<String, Object> sessionMap = this.getSessionMap();
        sessionMap.remove(name);
        if (otherNames != null) {
            for (String other : otherNames) {
                sessionMap.remove(other);
            }
        }
    }

    public abstract Map<String, Object> getSessionMap();

    public <T> T replaceInSession(String name, T newValue) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)name, (String)"name", (String)"replaceInSession");
        Map<String, Object> sessionMap = this.getSessionMap();
        if (newValue == null) {
            sessionMap.remove(name);
            return null;
        }
        this.getFromSession(name, newValue.getClass(), sessionMap, "Provided object: " + newValue + " is not compatible with previously assigned '" + name + "' object: " + CURRENT_PLACEHOLDER);
        sessionMap.put(name, newValue);
        return newValue;
    }

    public <T> T getFromSession(String name, Class<T> expectedClass) {
        return this.getFromSession(name, expectedClass, this.getSessionMap(), "Current object:### is not compatible with expected class " + expectedClass + " for '" + name + "'");
    }

    private <T> T getFromSession(String name, Class<T> expectedClass, Map<String, Object> sessionMap, String errorMessage) {
        Object result = sessionMap.get(name);
        if (result != null && !expectedClass.isAssignableFrom(result.getClass())) {
            throw new IllegalArgumentException(errorMessage.replace(CURRENT_PLACEHOLDER, result.toString()));
        }
        return expectedClass.cast(result);
    }
}

