/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity;

import java.util.Collections;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.portal.core.identity.UserActivity;
import org.jboss.portal.core.identity.UsersActivityStatsService;
import org.jboss.portal.jems.as.system.AbstractJBossService;

public class UsersActivityStatsServiceImpl
extends AbstractJBossService
implements UsersActivityStatsService,
NotificationListener {
    private static final Logger log = Logger.getLogger(UsersActivityStatsServiceImpl.class);
    private int userTrackerThreadsNumber = 10;
    private int updaterThreadsNumber = 1;
    private int updaterInterval = 1000;
    private int activityQueueLimit = 1000;
    private long activityTimeout = 1800000L;
    private Executor userTrackerExecutor;
    private ScheduledExecutorService updaterExecutor;
    private Queue activityQueue;
    private volatile Set activityResults = new HashSet();
    private String activityBroadcasterName;

    protected void startService() throws Exception {
        super.startService();
        this.activityQueue = new LinkedBlockingQueue(this.getActivityQueueLimit());
        this.userTrackerExecutor = Executors.newFixedThreadPool(this.getUserTrackerThreadsNumber());
        this.updaterExecutor = Executors.newScheduledThreadPool(this.getUpdaterThreadsNumber());
        this.updaterExecutor.scheduleWithFixedDelay(new Updater(this.activityQueue), this.getUpdaterInterval(), this.getUpdaterInterval(), TimeUnit.MILLISECONDS);
        if (this.activityBroadcasterName != null) {
            this.server.addNotificationListener(new ObjectName(this.activityBroadcasterName), this, null, null);
        } else {
            this.addNotificationListener(this, null, null);
        }
    }

    protected void stopService() throws Exception {
        super.stopService();
    }

    public Set getActiveUsersIds(long period) {
        long currentTime = System.currentTimeMillis();
        HashSet<String> results = new HashSet<String>();
        for (UserActivity ua : this.activityResults) {
            if (currentTime - ua.getTimestamp() >= period || ua.getId().equals("guest")) continue;
            results.add(ua.getSessionId());
        }
        return results;
    }

    public int getActiveSessionCount(long period) {
        long currentTime = System.currentTimeMillis();
        int results = 0;
        for (UserActivity ua : this.activityResults) {
            if (currentTime - ua.getTimestamp() >= period) continue;
            ++results;
        }
        return results;
    }

    public Set getActiveUsersNames(long period) {
        long currentTime = System.currentTimeMillis();
        HashSet<String> results = new HashSet<String>();
        for (UserActivity ua : this.activityResults) {
            if (currentTime - ua.getTimestamp() >= period || ua.getId().equals("guest")) continue;
            results.add(ua.getId());
        }
        return results;
    }

    public Set getUsersActivities(long period) {
        long currentTime = System.currentTimeMillis();
        HashSet<UserActivity> results = new HashSet<UserActivity>();
        for (UserActivity ua : this.activityResults) {
            if (currentTime - ua.getTimestamp() >= period) continue;
            results.add(ua);
        }
        return results;
    }

    public void registerActivity(UserActivity userActivity) {
        try {
            Notification notification = new Notification(Integer.toString(userActivity.getType()), this.getServiceName(), userActivity.getTimestamp(), userActivity.getTimestamp(), userActivity.getId() + "_" + userActivity.getSessionId());
            if (this.activityBroadcasterName != null) {
                log.debug((Object)"Broadcasting user activity notification ");
                this.server.invoke(new ObjectName(this.activityBroadcasterName), "sendNotification", new Object[]{notification}, new String[]{Notification.class.getName()});
            } else {
                log.debug((Object)"Sending local user activity notification ");
                this.sendNotification(notification);
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to send user activity notification: ", (Throwable)e);
        }
    }

    public void handleNotification(Notification notification, Object object) {
        log.debug((Object)"Handling  user activity notification ");
        final UserActivity ac = new UserActivity(notification);
        FutureTask task = new FutureTask(new Callable(){

            public Object call() throws Exception {
                boolean success = UsersActivityStatsServiceImpl.this.activityQueue.offer(ac);
                if (log.isTraceEnabled() && !success) {
                    log.trace((Object)"Failed track user activity - activityQueue is full ");
                }
                return null;
            }
        });
        this.userTrackerExecutor.execute(task);
    }

    public int getUserTrackerThreadsNumber() {
        return this.userTrackerThreadsNumber;
    }

    public void setUserTrackerThreadsNumber(int userTrackerThreadsNumber) {
        this.userTrackerThreadsNumber = userTrackerThreadsNumber;
    }

    public int getUpdaterThreadsNumber() {
        return this.updaterThreadsNumber;
    }

    public void setUpdaterThreadsNumber(int updaterThreadsNumber) {
        this.updaterThreadsNumber = updaterThreadsNumber;
    }

    public int getUpdaterInterval() {
        return this.updaterInterval;
    }

    public void setUpdaterInterval(int updaterInterval) {
        this.updaterInterval = updaterInterval;
    }

    public int getActivityQueueLimit() {
        return this.activityQueueLimit;
    }

    public void setActivityQueueLimit(int activityQueueLimit) {
        this.activityQueueLimit = activityQueueLimit;
    }

    public long getActivityTimeout() {
        return this.activityTimeout;
    }

    public void setActivityTimeout(long activityTimeout) {
        this.activityTimeout = activityTimeout;
    }

    public String getActivityBroadcasterName() {
        return this.activityBroadcasterName;
    }

    public void setActivityBroadcasterName(String activityBroadcasterName) {
        this.activityBroadcasterName = activityBroadcasterName;
    }

    private class Updater
    implements Runnable {
        private final Queue activityQueue;

        public Updater(Queue activityQueue) {
            this.activityQueue = activityQueue;
        }

        private Updater() {
            this.activityQueue = null;
        }

        public void run() {
            long currentTime = System.currentTimeMillis();
            Set stillActive = UsersActivityStatsServiceImpl.this.getUsersActivities(UsersActivityStatsServiceImpl.this.activityTimeout);
            while (!this.activityQueue.isEmpty()) {
                UserActivity activity = (UserActivity)this.activityQueue.poll();
                if (activity == null || currentTime - activity.getTimestamp() >= UsersActivityStatsServiceImpl.this.activityTimeout) continue;
                if (activity.getType() != 1) {
                    stillActive.add(activity);
                    continue;
                }
                stillActive.remove(activity);
            }
            UsersActivityStatsServiceImpl.this.activityResults = Collections.unmodifiableSet(stillActive);
        }
    }
}

