/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.server.aspects.server;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.jboss.portal.common.invocation.InvocationException;
import org.jboss.portal.server.ServerInterceptor;
import org.jboss.portal.server.ServerInvocation;
import org.jboss.portal.server.ServerInvocationContext;
import org.jboss.portal.web.RequestDispatchCallback;
import org.jboss.portal.web.ServletContainer;
import org.jboss.portal.web.ServletContainerFactory;

public class SignOutInterceptor
extends ServerInterceptor {
    private static final Invalidation invalidator = new Invalidation();
    private static final Logger log = Logger.getLogger(SignOutInterceptor.class);
    private static final String KEY = "org.jboss.portal.session.contexts";
    private static final ThreadLocal localContexts = new ThreadLocal(){

        protected Object initialValue() {
            return new HashSet();
        }
    };
    private ServletContainerFactory servletContainerFactory;

    public static Set getSet() {
        return (Set)localContexts.get();
    }

    public ServletContainerFactory getServletContainerFactory() {
        return this.servletContainerFactory;
    }

    public void setServletContainerFactory(ServletContainerFactory servletContainerFactory) {
        this.servletContainerFactory = servletContainerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invoke(ServerInvocation invocation) throws Exception, InvocationException {
        try {
            SignOutInterceptor.getSet().clear();
            invocation.invokeNext();
        }
        finally {
            this.after(invocation);
        }
    }

    private void after(ServerInvocation invocation) {
        ServerInvocationContext context = invocation.getServerContext();
        HttpSession session = context.getClientRequest().getSession();
        HashSet contexts = (HashSet)session.getAttribute(KEY);
        if (contexts == null) {
            contexts = new HashSet();
            session.setAttribute(KEY, contexts);
        }
        contexts.addAll(SignOutInterceptor.getSet());
        SignOutInterceptor.getSet().clear();
        if (invocation.getResponse().getWantSignOut()) {
            HttpServletRequest req;
            block7: {
                ServletContext portalContext = session.getServletContext();
                req = invocation.getServerContext().getClientRequest();
                HttpServletResponse resp = invocation.getServerContext().getClientResponse();
                for (String dispatchContextName : contexts) {
                    ServletContext dispatchContext = portalContext.getContext(dispatchContextName);
                    if (dispatchContext == null) continue;
                    try {
                        ServletContainer servletContainer = this.servletContainerFactory.getServletContainer();
                        servletContainer.include(dispatchContext, req, resp, (RequestDispatchCallback)invalidator, null);
                    }
                    catch (Exception e) {
                        log.error((Object)"An error occured when trying to invalidate the session", (Throwable)e);
                    }
                }
                try {
                    session.invalidate();
                }
                catch (IllegalStateException stateException) {
                    if (stateException.toString().indexOf("invalidate: Session already invalidated") != -1) break block7;
                    throw stateException;
                }
            }
            req.setAttribute("org.jboss.portal.logout", (Object)"true");
        }
    }

    public static class Invalidation
    implements RequestDispatchCallback {
        public Object doCallback(ServletContext servletContext, HttpServletRequest req, HttpServletResponse resp, Object handback) throws ServletException, IOException {
            HttpSession session = req.getSession(false);
            if (session != null) {
                session.invalidate();
            }
            return null;
        }
    }
}

